#include "stdafx.h"
#include "Undo.h"

UndoManager::UndoManager()
	: current_(0)
{
}

void UndoManager::Clear()
{
	actions_.clear();
	current_ = 0;
}

void UndoManager::Append(ActionList list)
{
	actions_.erase(actions_.begin()+current_,actions_.end());
	actions_.push_back(list);
	current_ = actions_.size();
}

bool UndoManager::Undo(IBuffer *buffer)
{
	if(!IsEnabledUndoing()) return false;
	if(!Action::Undo(actions_[current_-1],buffer)) return false;
	current_--;
	return true;
}

bool UndoManager::Redo(IBuffer *buffer)
{
	if(!IsEnabledRedoing()) return false;
	if(!Action::Redo(actions_[current_],buffer)) return false;
	current_++;
	return true;
}

bool UndoManager::IsEnabledUndoing() const
{
	return (!actions_.empty())&&(current_!=0);
}

bool UndoManager::IsEnabledRedoing() const
{
	return current_!=actions_.size();
}
