#include "stdafx.h"
#include "Utility.h"
#include <boost/algorithm/string/trim.hpp>

//lexical_cast͈ĊOgȂ

std::string convert_to_hexstring(ulong hexvalue)
{
	std::string str;
	do{
		char character = static_cast<char>(hexvalue%16);
		if(character<10){
			str.insert(str.begin(),1,('0'+character));	
		}else{
			str.insert(str.begin(),1,('A'+character-10));
		}
		hexvalue /= 16;
	}while(hexvalue);

	return str;
}

boost::optional<ulong> convert_from_hexstring(const std::string& hexstring)
{
	boost::optional<ulong> returnvalue;

	std::string str = hexstring;
	boost::algorithm::trim(str);

	ulong hexvalue = 0;
	for(std::string::iterator it=str.begin(); it!=str.end(); ++it){
		hexvalue *= 16;

		char character = *it;
		if('0'<=character && character<='9'){
			hexvalue += character-'0';
		}else if('A'<=character && character<='F'){
			hexvalue += character-'A'+10;
		}else if('a'<=character && character<='f'){
			hexvalue += character-'a'+10;
		}else{
			return returnvalue;
		}
	}

	returnvalue = hexvalue;
	return returnvalue;
}

ulong get_max_address_column(ulong datasize)
{
	ulong columncount = 0;
	do{
		datasize /= 16;
		columncount++;
	}while(datasize);

	return columncount;
}

