/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Core - Excelt@CJava痘p邽߂̋ʊ
 *
 * $Id: BookData.java 40 2009-05-20 08:08:45Z yuta-takahashi $
 * $Revision: 40 $
 *
 * This file is part of ExCella Core.
 *
 * ExCella Core is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Core.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * [NubN̉͌ʂێNX
 * 
 * @since 1.0
 */
public class BookData {
    /**
     * ͌(V[gAV[gf[^)ێ}bv
     */
    private Map<String, SheetData> sheetDataMap = new LinkedHashMap<String, SheetData>();

    /**
     * ǉꂽێV[g̈ꗗ
     */
    private List<String> sheetNameList = new ArrayList<String>();

    /**
     * V[gf[^݂邩ǂ̃`FbN
     * 
     * @param sheetName V[g
     * @return ݂ꍇtrue,݂Ȃꍇfalse;
     */
    public boolean containsSheet( String sheetName) {
        return sheetDataMap.containsKey( sheetName);
    }

    /**
     * V[gf[^̎擾
     * 
     * @param sheetName V[g
     * @return V[gf[^
     */
    public SheetData getSheetData( String sheetName) {
        return sheetDataMap.get( sheetName);
    }

    /**
     * ܂܂V[g̈ꗗ擾
     * 
     * @return ܂܂V[g̈ꗗ
     */
    public List<String> getSheetNames() {
        return sheetNameList;
    }

    /**
     * V[gf[^̐ݒ
     * 
     * @param sheetName V[g
     * @param sheetData V[gf[^
     * @return V[gf[^
     */
    public SheetData putSheetData( String sheetName, SheetData sheetData) {
        // ɃXgɑ݂΍폜ĈUǉ
        if ( sheetNameList.contains( sheetName)) {
            sheetNameList.remove( sheetName);
        }
        sheetNameList.add( sheetName);
        return sheetDataMap.put( sheetName, sheetData);
    }

    /**
     * ܂܂V[gf[^̈ꗗ擾
     * 
     * @return ܂܂V[gf[^̈ꗗ
     */
    public Collection<SheetData> getSheetDatas() {
        return sheetDataMap.values();
    }

    /**
     * SV[gf[^̃NA
     */
    public void clear() {
        sheetDataMap.clear();
    }
}
