/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Core - Excelt@CJava痘p邽߂̋ʊ
 *
 * $Id: SheetData.java 156 2010-09-09 04:16:50Z akira-yokoi $
 * $Revision: 156 $
 *
 * This file is part of ExCella Core.
 *
 * ExCella Core is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Core.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * ^OPʂŃV[g̉͌ʂێNX
 * 
 * @since 1.0
 */
public class SheetData {

    /**
     * V[g
     */
    private String sheetName = null;

    /**
     * ^OɃf[^ێ}bv
     */
    private Map<String, List<Object>> tagValueMap = new HashMap<String, List<Object>>();

    /**
     * ǉꂽێL[̈ꗗ
     */
    private List<String> keyList = new ArrayList<String>();

    /**
     * RXgN^
     * 
     * @param sheetName V[g
     */
    public SheetData( String sheetName) {
        this.sheetName = sheetName;
    }

    /**
     * V[g̎擾
     * 
     * @return V[g
     */
    public String getSheetName() {
        return sheetName;
    }

    /**
     * V[g̐ݒ
     * 
     * @param sheetName V[g
     */
    public void setSheetName( String sheetName) {
        this.sheetName = sheetName;
    }

    /**
     * ^OɑΉ͌ʂ̒ǉ
     * 
     * @param tagName ^O
     * @param result ^OɑΉ͌
     */
    public void put( String tagName, Object result) {
        // ɃXgɑ݂΍폜ĈUǉ
        if ( keyList.contains( tagName)) {
            keyList.remove( tagName);
        }
        keyList.add( tagName);

        List<Object> values = tagValueMap.get( tagName);
        if( values == null){
        	values = new ArrayList<Object>();
        	tagValueMap.put( tagName, values);
        }
        values.add( result);
    }

    /**
     * ^OɑΉ͌ʂ̎擾
     * 
     * @param tagName ^O
     * @return ^OɑΉ͌
     */
    public Object get( String tagName) {
    	List<Object> results = tagValueMap.get( tagName);
    	if( results != null && ! results.isEmpty()){
    		// ŏIvfԂ(ʌ݊)
    		return results.get( results.size() - 1);
    	}
        return null;
    }
    
    /**
     * ^OɑΉ͌ʂ̎擾
     * 
     * @param tagName ^O
     * @return ^OɑΉ͌
     */
    public List<Object> getList( String tagName) {
        return tagValueMap.get( tagName);
    }

    /**
     * ێ^Öꗗ擾
     * 
     * @return ێ^Öꗗ
     */
    public Set<String> getTagNames() {
        return tagValueMap.keySet();
    }

    /**
     * ^O݂邩ǂ̃`FbN
     * 
     * @param tagName Ώۂ̃^O
     * @return ݂ꍇtrue,݂Ȃꍇfalse
     */
    public boolean containsTag( String tagName) {
        return tagValueMap.containsKey( tagName);
    }

    /**
     * putꂽ̃L[̈ꗗ擾
     * 
     * @return L[̈ꗗ擾
     */
    public List<String> getKeyList() {
        return keyList;
    }

    /**
     * f[^̍폜
     * 
     * @param key 폜Ώۂ̃L[
     * @return 폜Ώۂ̃f[^
     */
    public Object remove( Object key) {
        keyList.remove( key);
        return tagValueMap.remove( key);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append( "=====================" + sheetName + "=====================");
        List<String> keys = getKeyList();
        for ( String key : keys) {
            builder.append( "\n");
            builder.append( "\t");
            builder.append( key);
            builder.append( "\t");
            builder.append( get( key));
        }
        return builder.toString();
    }
}
