/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Core - Excelt@CJava痘p邽߂̋ʊ
 *
 * $Id: ObjectsPropertyParser.java 2 2009-05-08 07:39:20Z yuta-takahashi $
 * $Revision: 2 $
 *
 * This file is part of ExCella Core.
 *
 * ExCella Core is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Core.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.core.tag.excel2java;

import java.util.Map;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.bbreak.excella.core.exception.ParseException;

/**
 * Objectsp[TpƎvpeB̓NX
 * 
 * @since 1.0
 */
public abstract class ObjectsPropertyParser {

    /**
     * ̃vZbTŏ^O
     */
    private String tag;

    /**
     * RXgN^
     * @param tag ^O
     */
    public ObjectsPropertyParser( String tag) {
        this.tag = tag;
    }

    /**
     * ^O擾
     * 
     * @return tag ^O
     */
    public String getTag() {
        return tag;
    }

    /**
     * ^Oݒ肷
     * 
     * @param tag ^O
     */
    public void setTag( String tag) {
        this.tag = tag;
    }

    /**
     * p[Xsۂ̔
     * 
     * @param sheet ΏۃV[g
     * @param tagCell ΏۃZ
     * @return Ώۂ̏ꍇTrueAΏۊȌꍇFalse
     * @throws ParseException
     */
    public boolean isParse( Sheet sheet, Cell tagCell) throws ParseException {
        if ( tagCell == null) {
            return false;
        }

        // 񂩂A^O܂ރZ̏ꍇ͏Ώ
        if ( tagCell.getCellType() == Cell.CELL_TYPE_STRING) {
            if ( tagCell.getStringCellValue().contains( tag)) {
                return true;
            }
        }
        return false;
    }

    /**
     * p[Xs
     * 
     * @param object ΏۃIuWFNg
     * @param cellValue Z̒l
     * @param tag ^O
     * @param params p[^̃}bv
     * @throws ParseException
     */
    public abstract void parse( Object object, Object cellValue, String tag, Map<String, String> params) throws ParseException;
}
