/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Core - Excelt@CJava痘p邽߂̋ʊ
 *
 * $Id: TagUtil.java 2 2009-05-08 07:39:20Z yuta-takahashi $
 * $Revision: 2 $
 *
 * This file is part of ExCella Core.
 *
 * ExCella Core is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Core.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.core.util;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

import org.bbreak.excella.core.tag.TagParser;

/**
 * ^O`샆[eBeB
 * 
 * @since 1.0
 */
public class TagUtil {

    /**
     * RXgN^
     */
    private TagUtil() {
    }

    /**
     * ^O`p[^("," "="ŕ}bv)擾
     * 
     * @param tagDef ^O`
     * @return p[^̃}bv
     */
    public static Map<String, String> getParams( String tagDef) {

        Map<String, String> params = new HashMap<String, String>();

        String paramDef = getParam( tagDef);

        if ( paramDef == null) {
            return params;
        }

        // ,ŕ
        StringTokenizer commaTokenizer = new StringTokenizer( paramDef, TagParser.PARAM_DELIM);
        while ( commaTokenizer.hasMoreTokens()) {
            String keyValue = ( String) commaTokenizer.nextToken();
            if ( keyValue.indexOf( TagParser.VALUE_DELIM) == -1) {
                params.put( "", keyValue);
            } else {
                // =ŕ
                StringTokenizer eqTokenizer = new StringTokenizer( keyValue, TagParser.VALUE_DELIM);
                while ( eqTokenizer.hasMoreTokens()) {
                    params.put( eqTokenizer.nextToken(), eqTokenizer.nextToken());
                }
            }
        }
        return params;
    }

    /**
     * ^O`p[[^̕擾B<BR>
     * ^O`̊Jn݂ȂꍇnullԂB
     * 
     * @param tagDef ^O`
     * @return p[^
     */
    public static String getParam( String tagDef) {

        return getParam( tagDef, TagParser.TAG_PARAM_PREFIX, TagParser.TAG_PARAM_SUFFIX);
    }

    /**
     * ^O`p[[^̕擾B<BR>
     * ^O`̊Jn݂ȂꍇnullԂB
     * 
     * @param tagDef ^O`
     * @param tagParamPrefix ^O̊Jn
     * @param tagParamSuffix ^ȌI
     * @return p[^
     */
    public static String getParam( String tagDef, String tagParamPrefix, String tagParamSuffix) {

        String param = null;

        int paramStartIdx = tagDef.indexOf( tagParamPrefix) + 1;
        int paramEndIdx = tagDef.lastIndexOf( tagParamSuffix);

        if ( paramStartIdx == 0) {
            return param;
        }

        // p[^擾
        param = tagDef.substring( paramStartIdx, paramEndIdx);

        return param;
    }

    /**
     * ^O`p[^擾
     * 
     * @param tagDef ^O`
     * @return p[^
     */
    public static String getTag( String tagDef) {

        return getTag( tagDef, TagParser.TAG_PARAM_PREFIX);
    }

    /**
     * ^O`p[^擾
     * 
     * @param tagDef ^O`
     * @param tagParamPrefix ^O̊Jn
     * @return p[^
     */
    public static String getTag( String tagDef, String tagParamPrefix) {

        int paramStartIdx = tagDef.indexOf( tagParamPrefix);
        if ( paramStartIdx == -1) {
            return tagDef;
        }
        return tagDef.substring( 0, paramStartIdx);
    }

    /**
     * x[XƂȂlƃp[^璲̒l擾
     * 
     * @param baseValue x[XƂȂl
     * @param paramMap p[^̃}bv
     * @param paramKey p[^̃L[
     * @param defaultAdjust p[^ɃL[݂Ȃꍇ̒l
     * @return ̒l
     */
    public static int adjustValue( int baseValue, Map<String, String> paramMap, String paramKey, int defaultAdjust) {
        int adjustValue = baseValue;

        if ( paramMap.containsKey( paramKey)) {
            String value = paramMap.get( paramKey);
            adjustValue += Integer.valueOf( value);
        } else {
            adjustValue += defaultAdjust;
        }
        return adjustValue;
    }
}
