/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Core - Excelt@CJava痘p邽߂̋ʊ
 *
 * $Id: ArraysParserTest.java 143 2009-11-13 06:01:09Z akira-yokoi $
 * $Revision: 143 $
 *
 * This file is part of ExCella Core.
 *
 * ExCella Core is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Core.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.core.tag.excel2java;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import java.util.List;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.bbreak.excella.core.WorkbookTest;
import org.bbreak.excella.core.exception.ParseException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

/**
 * ArraysParsereXgNX
 * 
 * @since 1.0
 */
public class ArraysParserTest extends WorkbookTest {

    /**
     * RXgN^
     * 
     * @param version Excelt@C̃o[W
     */
    public ArraysParserTest( String version) {
        super( version);
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public final void testArraysParser() throws ParseException {
        Workbook wk = getWorkbook();
        Sheet sheet1 = wk.getSheetAt( 0);
        Sheet sheet2 = wk.getSheetAt( 1);
        Sheet sheet3 = wk.getSheetAt( 2);
        Sheet sheet4 = wk.getSheetAt( 3);
        ArraysParser arraysParser = new ArraysParser( "@Arrays");
        String tag = arraysParser.getTag();
        arraysParser.setTag( tag);
        Cell tagCell = null;
        Object data = null;
        List<Object[]> list = null;

        // No.1 p[^
        tagCell = sheet1.getRow( 5).getCell( 0);
        list = arraysParser.parse( sheet1, tagCell, data);
        Object[] arrays = list.get( 0);
        assertEquals( "value1-1", arrays[0]);
        assertEquals( "value2-1", arrays[1]);
        assertEquals( "value3-1", arrays[2]);
        assertEquals( 3, arrays.length);
        arrays = list.get( 1);
        assertEquals( "value1-2", arrays[0]);
        assertEquals( "value2-2", arrays[1]);
        assertEquals( "value3-2", arrays[2]);
        assertEquals( 3, arrays.length);
        arrays = list.get( 2);
        assertEquals( "value1-3", arrays[0]);
        assertEquals( "value2-3", arrays[1]);
        assertEquals( "value3-3", arrays[2]);
        assertEquals( 3, arrays.length);
        arrays = list.get( 3);
        assertEquals( "value1-4", arrays[0]);
        assertEquals( "value2-4", arrays[1]);
        assertEquals( "value3-4", arrays[2]);
        assertEquals( "value4-1", arrays[3]);
        assertEquals( 4, arrays.length);
        arrays = list.get( 4);
        assertEquals( "value1-5", arrays[0]);
        assertEquals( null, arrays[1]);
        assertEquals( "value3-5", arrays[2]);
        assertEquals( "value4-2", arrays[3]);
        assertEquals( 4, arrays.length);
        arrays = list.get( 5);
        assertEquals( "value1-6", arrays[0]);
        assertEquals( "value2-5", arrays[1]);
        assertEquals( 2, arrays.length);
        assertEquals( 6, list.size());
        
        // No.2 p[^L
        tagCell = sheet2.getRow( 5).getCell( 0);
        list.clear();
        list = arraysParser.parse( sheet2, tagCell, data);
        arrays = list.get( 0);
        assertEquals( "value1-1", arrays[0]);
        assertEquals( "value2-1", arrays[1]);
        assertEquals( 2, arrays.length);
        arrays = list.get( 1);
        assertEquals( "value1-2", arrays[0]);
        assertEquals( "value2-2", arrays[1]);
        assertEquals( 2, arrays.length);
        arrays = list.get( 2);
        assertEquals( "value1-3", arrays[0]);
        assertEquals( "value2-3", arrays[1]);
        assertEquals( 2, arrays.length);
        assertEquals( 3, list.size());
        
        // No.3 JnAIw
        tagCell = sheet2.getRow( 13).getCell( 0);
        list.clear();
        list = arraysParser.parse( sheet2, tagCell, data);
        arrays = list.get( 0);
        assertEquals( "value1-4", arrays[0]);
        assertEquals( "value2-4", arrays[1]);
        assertEquals( 2, arrays.length);
        arrays = list.get( 1);
        assertEquals( "value1-5", arrays[0]);
        assertEquals( "value2-5", arrays[1]);
        assertEquals( 2, arrays.length);
        arrays = list.get( 2);
        assertEquals( "value1-6", arrays[0]);
        assertEquals( "value2-6", arrays[1]);
        assertEquals( 2, arrays.length);
        assertEquals( 3, list.size());

        // No.4 f[^snullsL
        tagCell = sheet2.getRow( 22).getCell( 0);
        list.clear();
        list = arraysParser.parse( sheet2, tagCell, data);
        arrays = list.get( 0);
        assertEquals( "value1-7", arrays[0]);
        assertEquals( "value2-7", arrays[1]);
        assertEquals( 2, arrays.length);
        arrays = list.get( 1);
        assertEquals( "value1-8", arrays[0]);
        assertEquals( "value2-8", arrays[1]);
        assertEquals( 2, arrays.length);
        arrays = list.get( 2);
        assertEquals( "value1-9", arrays[0]);
        assertEquals( "value2-9", arrays[1]);
        assertEquals( 2, arrays.length);
        assertEquals( 3, list.size());

        // No.5 f[^snullZL
        tagCell = sheet2.getRow( 31).getCell( 0);
        list.clear();
        list = arraysParser.parse( sheet2, tagCell, data);
        arrays = list.get( 0);
        assertEquals( null, arrays[0]);
        assertEquals( "value2-10", arrays[1]);
        assertEquals( "value3-1", arrays[2]);
        assertEquals( 3, arrays.length);
        arrays = list.get( 1);
        assertEquals( "value1-10", arrays[0]);
        assertEquals( null, arrays[1]);
        assertEquals( "value3-2", arrays[2]);
        assertEquals( 3, arrays.length);
        arrays = list.get( 2);
        assertEquals( "value1-11", arrays[0]);
        assertEquals( "value2-11", arrays[1]);
        assertEquals( 2, arrays.length);
        assertEquals( 3, list.size());

        // No.6 Jnw
        tagCell = sheet2.getRow( 39).getCell( 0);
        list.clear();
        list = arraysParser.parse( sheet2, tagCell, data);
        arrays = list.get( 0);
        assertEquals( "value2-12", arrays[0]);
        assertEquals( "value3-3", arrays[1]);
        assertEquals( 2, arrays.length);
        arrays = list.get( 1);
        assertEquals( "value2-13", arrays[0]);
        assertEquals( "value3-4", arrays[1]);
        assertEquals( 2, arrays.length);
        assertEquals( 2, list.size());

        // No.7 Iw
        tagCell = sheet2.getRow( 46).getCell( 0);
        list.clear();
        list = arraysParser.parse( sheet2, tagCell, data);
        arrays = list.get( 0);
        assertEquals( "value1-14", arrays[0]);
        assertEquals( "value2-14", arrays[1]);
        assertEquals( null, arrays[2]);
        assertEquals( null, arrays[3]);
        assertEquals( null, arrays[4]);
        assertEquals( 5, arrays.length);
        arrays = list.get( 1);
        assertEquals( "value1-15", arrays[0]);
        assertEquals( "value2-15", arrays[1]);
        assertEquals( "value3-5", arrays[2]);
        assertEquals( null, arrays[3]);
        assertEquals( null, arrays[4]);
        assertEquals( 5, arrays.length);
        assertEquals( 2, list.size());

        // No.8 JnEIw
        tagCell = sheet2.getRow( 53).getCell( 1);
        list.clear();
        list = arraysParser.parse( sheet2, tagCell, data);
        arrays = list.get( 0);
        assertEquals( "value3-6", arrays[0]);
        assertEquals( "value4-1", arrays[1]);
        assertEquals( null, arrays[2]);
        assertEquals( null, arrays[3]);
        assertEquals( 4, arrays.length);
        arrays = list.get( 1);
        assertEquals( null, arrays[0]);
        assertEquals( "value4-2", arrays[1]);
        assertEquals( "value5-1", arrays[2]);
        assertEquals( null, arrays[3]);
        assertEquals( 4, arrays.length);
        arrays = list.get( 2);
        assertEquals( null, arrays[0]);
        assertEquals( null, arrays[1]);
        assertEquals( null, arrays[2]);
        assertEquals( null, arrays[3]);
        assertEquals( 4, arrays.length);
        assertEquals( 3, list.size());

        // No.9 }CiX͈͎wif[^sj
        tagCell = sheet3.getRow( 7).getCell( 0);
        list.clear();
        list = arraysParser.parse( sheet3, tagCell, data);
        arrays = list.get( 0);
        assertEquals( "value1-1", arrays[0]);
        assertEquals( "value2-1", arrays[1]);
        assertEquals( 2, arrays.length);
        arrays = list.get( 1);
        assertEquals( "value1-2", arrays[0]);
        assertEquals( "value2-2", arrays[1]);
        assertEquals( 2, arrays.length);
        arrays = list.get( 2);
        assertEquals( "value1-3", arrays[0]);
        assertEquals( "value2-3", arrays[1]);
        assertEquals( 2, arrays.length);
        arrays = list.get( 3);
        assertEquals( "value1-4", arrays[0]);
        assertEquals( "value2-4", arrays[1]);
        assertEquals( 2, arrays.length);
        assertEquals( 4, list.size());

        // No.10 }CiX͈͎wif[^j
        tagCell = sheet3.getRow( 12).getCell( 2);
        list.clear();
        list = arraysParser.parse( sheet3, tagCell, data);
        arrays = list.get( 0);
        assertEquals( "value2-6", arrays[0]);
        assertEquals( "value3-1", arrays[1]);
        assertEquals( "value4-1", arrays[2]);
        assertEquals( "value5-1", arrays[3]);
        assertEquals( 4, arrays.length);
        arrays = list.get( 1);
        assertEquals( "value2-7", arrays[0]);
        assertEquals( "value3-2", arrays[1]);
        assertEquals( "value4-2", arrays[2]);
        assertEquals( "value5-2", arrays[3]);
        assertEquals( 4, arrays.length);
        assertEquals( 2, list.size());

        // No.11 }CiX͈͎wif[^sEf[^j
        tagCell = sheet3.getRow( 21).getCell( 2);
        list.clear();
        list = arraysParser.parse( sheet3, tagCell, data);
        arrays = list.get( 0);
        assertEquals( "value2-8", arrays[0]);
        assertEquals( "value3-3", arrays[1]);
        assertEquals( "value4-3", arrays[2]);
        assertEquals( "value5-3", arrays[3]);
        assertEquals( 4, arrays.length);
        arrays = list.get( 1);
        assertEquals( "value2-9", arrays[0]);
        assertEquals( "value3-4", arrays[1]);
        assertEquals( "value4-4", arrays[2]);
        assertEquals( "value5-4", arrays[3]);
        assertEquals( 4, arrays.length);
        assertEquals( 2, list.size());

        // No.12 DataRowFrom > DataRowTo
        tagCell = sheet3.getRow( 30).getCell( 0);
        list.clear();
        try {
            list = arraysParser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 30, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
            System.out.println( "No.12:" + pe);
        }

        // No.13 DataColumnFrom > DataColumnTo
        tagCell = sheet3.getRow( 40).getCell( 0);
        list.clear();
        try {
            list = arraysParser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 40, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
            System.out.println( "No.13:" + pe);
        }

        // No.14 DataRowFromsilj
        tagCell = sheet3.getRow( 48).getCell( 0);
        list.clear();
        try {
            list = arraysParser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 48, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
            System.out.println( "No.14:" + pe);
        }

        // No.15 DataRowTosilj
        tagCell = sheet3.getRow( 51).getCell( 0);
        list.clear();
        try {
            list = arraysParser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 51, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
            System.out.println( "No.15:" + pe);
        }

        // No.16 DataColumnFromsilj
        tagCell = sheet3.getRow( 54).getCell( 0);
        list.clear();
        try {
            list = arraysParser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 54, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
            System.out.println( "No.16:" + pe);
        }

        // No.17 DataColumnTosilj
        tagCell = sheet3.getRow( 57).getCell( 0);
        list.clear();
        try {
            list = arraysParser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 57, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
            System.out.println( "No.17:" + pe);
        }

        // No.18 DataRowFromsilj
        tagCell = sheet3.getRow( 60).getCell( 0);
        list.clear();
        try {
            list = arraysParser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 60, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
            System.out.println( "No.18:" + pe);
        }

        // No.19 DataRowTosilj
        tagCell = sheet3.getRow( 63).getCell( 0);
        list.clear();
        try {
            list = arraysParser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 63, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
            System.out.println( "No.19:" + pe);
        }

        // No.20 DataColumnFromsilj
        tagCell = sheet3.getRow( 66).getCell( 0);
        list.clear();
        try {
            list = arraysParser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 66, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
            System.out.println( "No.20:" + pe);
        }

        // No.21 DataColumnTosilj
        tagCell = sheet3.getRow( 69).getCell( 0);
        list.clear();
        try {
            list = arraysParser.parse( sheet3, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 69, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
            System.out.println( "No.21:" + pe);
        }
        
        // No.22 DataColumnFromseXgiAŃf[^JnɃ}CiXwj
        tagCell = sheet4.getRow( 2).getCell( 0);
        list.clear();
        try {
            list = arraysParser.parse( sheet4, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 2, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
            System.out.println( "No.22:" + pe);
        }
        
        // No.23 DataColumnToseXgiAŃf[^IɃ}CiXwj
        tagCell = sheet4.getRow( 11).getCell( 0);
        list.clear();
        try {
            list = arraysParser.parse( sheet4, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 11, cell.getRow().getRowNum());
            assertEquals( 0, cell.getColumnIndex());
            System.out.println( "No.23:" + pe);
        }
        
        // No.24 DataRowFromseXgi1sڂŃf[^JnsɃ}CiXwj
        tagCell = sheet4.getRow( 0).getCell( 3);
        list.clear();
        try {
            list = arraysParser.parse( sheet4, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 0, cell.getRow().getRowNum());
            assertEquals( 3, cell.getColumnIndex());
            System.out.println( "No.24:" + pe);
        }

        // No.25 DataRowToseXgi1sڂŃf[^JnsɃ}CiXwj
        tagCell = sheet4.getRow( 0).getCell( 6);
        list.clear();
        try {
            list = arraysParser.parse( sheet4, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 0, cell.getRow().getRowNum());
            assertEquals( 6, cell.getColumnIndex());
            System.out.println( "No.25:" + pe);
        }

        // No.26 DataColumnFromseXgiŏIŃL[ɃvXwj
        tagCell = sheet4.getRow( 2).getCell( 11);
        list.clear();
        try {
            list = arraysParser.parse( sheet4, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 2, cell.getRow().getRowNum());
            assertEquals( 11, cell.getColumnIndex());
            System.out.println( "No.26:" + pe);
        }
        
        // No.27 DataColumnToseXgiŏIŒlɃvXwj
        tagCell = sheet4.getRow( 11).getCell( 11);
        list.clear();
        try {
            list = arraysParser.parse( sheet4, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 11, cell.getRow().getRowNum());
            assertEquals( 11, cell.getColumnIndex());
            System.out.println( "No.27:" + pe);
        }
        
        // No.28 DataRowFromseXgiŏIsŃf[^JnsɃvXwj
        tagCell = sheet4.getRow( 18).getCell( 3);
        list.clear();
        try {
            list = arraysParser.parse( sheet4, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 18, cell.getRow().getRowNum());
            assertEquals( 3, cell.getColumnIndex());
            System.out.println( "No.28:" + pe);
        }

        // No.29 DataRowToseXgiŏIsŃf[^IsɃvXwj
        tagCell = sheet4.getRow( 18).getCell( 6);
        list.clear();
        try {
            list = arraysParser.parse( sheet4, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 18, cell.getRow().getRowNum());
            assertEquals( 6, cell.getColumnIndex());
            System.out.println( "No.29:" + pe);
        }
        
        // No.30 f[^
        tagCell = sheet4.getRow( 18).getCell( 9);
        list.clear();
        try {
            list = arraysParser.parse( sheet4, tagCell, data);
            fail();
        } catch ( ParseException pe) {
            Cell cell = pe.getCell();
            assertEquals( 18, cell.getRow().getRowNum());
            assertEquals( 9, cell.getColumnIndex());
            System.out.println( "No.30:" + pe);
        }
    }
}
