/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.core;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.bbreak.excella.core.BookData;
import org.bbreak.excella.core.SheetData;
import org.bbreak.excella.core.SheetParser;
import org.bbreak.excella.core.exception.ExportException;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.exporter.book.BookExporter;
import org.bbreak.excella.core.exporter.sheet.SheetExporter;
import org.bbreak.excella.core.handler.ParseErrorHandler;
import org.bbreak.excella.core.listener.SheetParseListener;
import org.bbreak.excella.core.tag.TagParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookController {
    private static Log log = LogFactory.getLog(BookController.class);
    public static final String XSSF_SUFFIX = ".xlsx";
    public static final String HSSF_SUFFIX = ".xls";
    public static final String COMMENT_PREFIX = "-";
    private Workbook workbook;
    private List<String> sheetNames = new ArrayList<String>();
    private List<SheetTagParserInfo> tagParsers = new ArrayList<SheetTagParserInfo>();
    private List<SheetListenerInfo> sheetListeners = new ArrayList<SheetListenerInfo>();
    private List<BookExporter> bookExporters = new ArrayList<BookExporter>();
    private List<SheetExporterInfo> sheetExporters = new ArrayList<SheetExporterInfo>();
    private ParseErrorHandler errorHandler = null;
    private BookData bookData = new BookData();

    public BookController(String filepath) throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)(filepath + "\u306e\u8aad\u307f\u8fbc\u307f\u3092\u958b\u59cb\u3057\u307e\u3059"));
        }
        if (filepath.endsWith(XSSF_SUFFIX)) {
            this.workbook = new XSSFWorkbook(filepath);
        } else {
            FileInputStream stream = new FileInputStream(filepath);
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)stream);
            this.workbook = new HSSFWorkbook(fs);
            stream.close();
        }
        int numOfSheets = this.workbook.getNumberOfSheets();
        for (int sheetCnt = 0; sheetCnt < numOfSheets; ++sheetCnt) {
            String sheetName = this.workbook.getSheetName(sheetCnt);
            this.sheetNames.add(sheetName);
        }
    }

    public BookController(Workbook workbook) {
        this.workbook = workbook;
        int numOfSheets = workbook.getNumberOfSheets();
        for (int sheetCnt = 0; sheetCnt < numOfSheets; ++sheetCnt) {
            String sheetName = workbook.getSheetName(sheetCnt);
            this.sheetNames.add(sheetName);
        }
    }

    public void parseBook() throws ParseException, ExportException {
        this.parseBook(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseBook(Object data) throws ParseException, ExportException {
        this.bookData.clear();
        for (String sheetName : this.sheetNames) {
            if (sheetName.startsWith(COMMENT_PREFIX)) continue;
            SheetData sheetData = this.parseSheet(sheetName, data);
            this.bookData.putSheetData(sheetName, sheetData);
        }
        for (BookExporter exporter : this.bookExporters) {
            if (exporter == null) continue;
            exporter.setup();
            try {
                exporter.export(this.workbook, this.bookData);
            }
            finally {
                exporter.tearDown();
            }
        }
    }

    public BookData getBookData() {
        return this.bookData;
    }

    public Workbook getBook() {
        return this.workbook;
    }

    public SheetData parseSheet(String sheetName) throws ParseException, ExportException {
        return this.parseSheet(sheetName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SheetData parseSheet(String sheetName, Object data) throws ParseException, ExportException {
        Sheet sheet = this.workbook.getSheet(sheetName);
        SheetData sheetData = null;
        try {
            String targetSheetName;
            SheetParser sheetParser = new SheetParser();
            if (log.isInfoEnabled()) {
                log.info((Object)("\u30b7\u30fc\u30c8[" + sheetName + "]\u306e\u51e6\u7406\u3092\u958b\u59cb\u3057\u307e\u3059"));
            }
            for (SheetTagParserInfo parserInfo : this.tagParsers) {
                targetSheetName = parserInfo.getSheetName();
                if (targetSheetName != null && !targetSheetName.equals(sheetName)) continue;
                sheetParser.addTagParser(parserInfo.getParser());
            }
            for (SheetListenerInfo listenerInfo : this.sheetListeners) {
                targetSheetName = listenerInfo.getSheetName();
                if (targetSheetName != null && !targetSheetName.equals(sheetName)) continue;
                listenerInfo.getListener().preParse(sheet, sheetParser);
            }
            sheetData = sheetParser.parseSheet(sheet, data);
            for (SheetListenerInfo listnerInfo : this.sheetListeners) {
                targetSheetName = listnerInfo.getSheetName();
                if (targetSheetName != null && !targetSheetName.equals(sheetName)) continue;
                listnerInfo.getListener().postParse(sheet, sheetParser, sheetData);
            }
        }
        catch (ParseException ex) {
            if (log.isWarnEnabled()) {
                log.warn((Object)(sheetName + "\u51e6\u7406\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f"), (Throwable)ex);
            }
            if (this.errorHandler != null) {
                this.errorHandler.notifyException(this.workbook, sheet, ex);
            }
            throw ex;
        }
        for (SheetExporterInfo exporterInfo : this.sheetExporters) {
            String targetSheetName = exporterInfo.getSheetName();
            if (targetSheetName != null && !targetSheetName.equals(sheetName)) continue;
            SheetExporter exporter = exporterInfo.getExporter();
            exporter.setup();
            try {
                exporter.export(sheet, sheetData);
            }
            finally {
                exporter.tearDown();
            }
        }
        return sheetData;
    }

    public List<String> getSheetNames() {
        return this.sheetNames;
    }

    public void addTagParser(TagParser<?> parser) {
        this.tagParsers.add(new SheetTagParserInfo(parser));
    }

    public void addTagParser(String sheetName, TagParser<?> parser) {
        this.tagParsers.add(new SheetTagParserInfo(sheetName, parser));
    }

    public void removeTagParser(String tag) {
        ArrayList<SheetTagParserInfo> removeList = new ArrayList<SheetTagParserInfo>();
        for (SheetTagParserInfo sheetTagParserInfo : this.tagParsers) {
            if (!sheetTagParserInfo.getParser().getTag().equals(tag)) continue;
            removeList.add(sheetTagParserInfo);
        }
        this.tagParsers.removeAll(removeList);
    }

    public void clearTagParsers() {
        this.tagParsers.clear();
    }

    public void addSheetParseListener(SheetParseListener listener) {
        this.sheetListeners.add(new SheetListenerInfo(listener));
    }

    public void addSheetParseListener(String sheetName, SheetParseListener listener) {
        this.sheetListeners.add(new SheetListenerInfo(sheetName, listener));
    }

    public void clearSheetParseListeners() {
        this.sheetListeners.clear();
    }

    public List<BookExporter> getExporter() {
        return this.bookExporters;
    }

    public void addSheetExporter(SheetExporter exporter) {
        this.sheetExporters.add(new SheetExporterInfo(exporter));
    }

    public void addSheetExporter(String sheetName, SheetExporter exporter) {
        this.sheetExporters.add(new SheetExporterInfo(sheetName, exporter));
    }

    public void clearSheetExporters() {
        this.sheetExporters.clear();
    }

    public ParseErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ParseErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void addBookExporter(BookExporter exporter) {
        this.bookExporters.add(exporter);
    }

    public void clearBookExporters() {
        this.bookExporters.clear();
    }

    private class SheetExporterInfo {
        private String sheetName = null;
        private SheetExporter exporter = null;

        public SheetExporterInfo(String sheetName, SheetExporter exporter) {
            this.sheetName = sheetName;
            this.exporter = exporter;
        }

        public SheetExporterInfo(SheetExporter exporter) {
            this.exporter = exporter;
        }

        public String getSheetName() {
            return this.sheetName;
        }

        public SheetExporter getExporter() {
            return this.exporter;
        }
    }

    private class SheetListenerInfo {
        private String sheetName = null;
        private SheetParseListener listener = null;

        public SheetListenerInfo(String sheetName, SheetParseListener listener) {
            this.sheetName = sheetName;
            this.listener = listener;
        }

        public SheetListenerInfo(SheetParseListener listener) {
            this.listener = listener;
        }

        public String getSheetName() {
            return this.sheetName;
        }

        public SheetParseListener getListener() {
            return this.listener;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SheetTagParserInfo {
        private String sheetName = null;
        private TagParser<?> parser = null;

        public SheetTagParserInfo(String sheetName, TagParser<?> parser) {
            this.sheetName = sheetName;
            this.parser = parser;
        }

        public SheetTagParserInfo(TagParser<?> parser) {
            this.parser = parser;
        }

        public String getSheetName() {
            return this.sheetName;
        }

        public TagParser<?> getParser() {
            return this.parser;
        }
    }
}

