/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.reports.exporter;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Workbook;
import org.bbreak.excella.core.BookData;
import org.bbreak.excella.core.exception.ExportException;
import org.bbreak.excella.reports.exporter.OoPdfExporter;
import org.bbreak.excella.reports.model.ConvertConfiguration;

public class OoPdfOutputStreamExporter
extends OoPdfExporter {
    private static final String TMP_FILE_PREFIX = "tmp";
    public static final String FORMAT_TYPE = "OUTPUT_STREAM_PDF";
    public static final String EXTENTION = ".pdf";
    private static Log log = LogFactory.getLog(OoPdfOutputStreamExporter.class);
    private OutputStream outputStream;

    public OoPdfOutputStreamExporter(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public String getFormatType() {
        return FORMAT_TYPE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void output(Workbook book, BookData bookdata, ConvertConfiguration configuration) throws ExportException {
        if (log.isInfoEnabled()) {
            log.info((Object)("\u51e6\u7406\u7d50\u679c\u3092" + this.outputStream.getClass().getCanonicalName() + "\u306b\u51fa\u529b\u3057\u307e\u3059"));
        }
        int point = this.getFilePath().indexOf(EXTENTION);
        StringBuffer sb = new StringBuffer(this.getFilePath());
        sb.insert(point, TMP_FILE_PREFIX);
        String tmpFilePath = sb.toString();
        this.setFilePath(tmpFilePath);
        super.output(book, bookdata, configuration);
        File pdfFile = new File(this.getFilePath());
        BufferedInputStream in = null;
        FilterOutputStream out = null;
        try {
            int b;
            in = new BufferedInputStream(new FileInputStream(pdfFile));
            out = new BufferedOutputStream(this.outputStream);
            while ((b = in.read()) != -1) {
                ((BufferedOutputStream)out).write(b);
            }
            return;
        }
        catch (IOException e) {
            throw new ExportException((Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                throw new ExportException((Throwable)e);
            }
            finally {
                pdfFile.delete();
            }
        }
    }
}

