/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.xssf.model.CalculationChain;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCell;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSSFRow
implements Row,
Comparable<XSSFRow> {
    private static final POILogger logger = POILogFactory.getLogger(XSSFRow.class);
    private final CTRow _row;
    private final TreeMap<Integer, Cell> _cells;
    private final XSSFSheet _sheet;

    protected XSSFRow(CTRow row, XSSFSheet sheet) {
        this._row = row;
        this._sheet = sheet;
        this._cells = new TreeMap();
        for (CTCell c : row.getCArray()) {
            XSSFCell cell = new XSSFCell(this, c);
            this._cells.put(cell.getColumnIndex(), cell);
            sheet.onReadCell(cell);
        }
    }

    public XSSFSheet getSheet() {
        return this._sheet;
    }

    public Iterator<Cell> cellIterator() {
        return this._cells.values().iterator();
    }

    public Iterator<Cell> iterator() {
        return this.cellIterator();
    }

    @Override
    public int compareTo(XSSFRow row) {
        int thisVal = this.getRowNum();
        if (row.getSheet() != this.getSheet()) {
            throw new IllegalArgumentException("The compared rows must belong to the same XSSFSheet");
        }
        int anotherVal = row.getRowNum();
        return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
    }

    public XSSFCell createCell(int columnIndex) {
        return this.createCell(columnIndex, 3);
    }

    public XSSFCell createCell(int columnIndex, int type) {
        CTCell ctcell = CTCell.Factory.newInstance();
        XSSFCell xcell = new XSSFCell(this, ctcell);
        xcell.setCellNum(columnIndex);
        if (type != 3) {
            xcell.setCellType(type);
        }
        this._cells.put(columnIndex, xcell);
        return xcell;
    }

    public XSSFCell getCell(int cellnum) {
        return this.getCell(cellnum, this._sheet.getWorkbook().getMissingCellPolicy());
    }

    public XSSFCell getCell(int cellnum, Row.MissingCellPolicy policy) {
        if (cellnum < 0) {
            throw new IllegalArgumentException("Cell index must be >= 0");
        }
        XSSFCell cell = (XSSFCell)this._cells.get(cellnum);
        if (policy == RETURN_NULL_AND_BLANK) {
            return cell;
        }
        if (policy == RETURN_BLANK_AS_NULL) {
            if (cell == null) {
                return cell;
            }
            if (cell.getCellType() == 3) {
                return null;
            }
            return cell;
        }
        if (policy == CREATE_NULL_AS_BLANK) {
            if (cell == null) {
                return this.createCell((short)cellnum, 3);
            }
            return cell;
        }
        throw new IllegalArgumentException("Illegal policy " + policy + " (" + policy.id + ")");
    }

    public short getFirstCellNum() {
        return (short)(this._cells.size() == 0 ? -1 : this._cells.firstKey());
    }

    public short getLastCellNum() {
        return (short)(this._cells.size() == 0 ? -1 : this._cells.lastKey() + 1);
    }

    public short getHeight() {
        return (short)(this.getHeightInPoints() * 20.0f);
    }

    public float getHeightInPoints() {
        if (this._row.isSetHt()) {
            return (float)this._row.getHt();
        }
        return this._sheet.getDefaultRowHeightInPoints();
    }

    public void setHeight(short height) {
        if (height == -1) {
            if (this._row.isSetHt()) {
                this._row.unsetHt();
            }
            if (this._row.isSetCustomHeight()) {
                this._row.unsetCustomHeight();
            }
        } else {
            this._row.setHt((double)height / 20.0);
            this._row.setCustomHeight(true);
        }
    }

    public void setHeightInPoints(float height) {
        this.setHeight((short)(height == -1.0f ? -1.0f : height * 20.0f));
    }

    public int getPhysicalNumberOfCells() {
        return this._cells.size();
    }

    public int getRowNum() {
        return (int)(this._row.getR() - 1L);
    }

    public void setRowNum(int rowIndex) {
        int maxrow = SpreadsheetVersion.EXCEL2007.getLastRowIndex();
        if (rowIndex < 0 || rowIndex > maxrow) {
            throw new IllegalArgumentException("Invalid row number (" + rowIndex + ") outside allowable range (0.." + maxrow + ")");
        }
        this._row.setR((long)(rowIndex + 1));
    }

    public boolean getZeroHeight() {
        return this._row.getHidden();
    }

    public void setZeroHeight(boolean height) {
        this._row.setHidden(height);
    }

    public void removeCell(Cell cell) {
        this._cells.remove(cell.getColumnIndex());
    }

    public CTRow getCTRow() {
        return this._row;
    }

    protected void onDocumentWrite() {
        ArrayList<CTCell> cArray = new ArrayList<CTCell>(this._cells.size());
        for (Cell cell : this._cells.values()) {
            XSSFCell c = (XSSFCell)cell;
            cArray.add(c.getCTCell());
        }
        this._row.setCArray(cArray.toArray(new CTCell[cArray.size()]));
    }

    public String toString() {
        return this._row.toString();
    }

    protected void shift(int n) {
        int rownum = this.getRowNum() + n;
        CalculationChain calcChain = this._sheet.getWorkbook().getCalculationChain();
        int sheetId = (int)this._sheet.sheet.getSheetId();
        Iterator<Cell> i$ = this.iterator();
        while (i$.hasNext()) {
            Cell c = i$.next();
            XSSFCell cell = (XSSFCell)c;
            if (calcChain != null) {
                calcChain.removeItem(sheetId, cell.getReference());
            }
            CTCell ctCell = cell.getCTCell();
            String r = new CellReference(rownum, cell.getColumnIndex()).formatAsString();
            ctCell.setR(r);
        }
        this.setRowNum(rownum);
    }
}

