/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.trans.tag.sheet2java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.bbreak.excella.core.SheetData;
import org.bbreak.excella.core.SheetParser;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.listener.SheetParseListener;
import org.bbreak.excella.core.tag.TagParser;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.core.util.TagUtil;
import org.bbreak.excella.trans.tag.sheet2java.SheetToJavaListener;
import org.bbreak.excella.trans.tag.sheet2java.SheetToJavaParser;
import org.bbreak.excella.trans.tag.sheet2java.SheetToJavaPropertyParser;
import org.bbreak.excella.trans.tag.sheet2java.SheetToJavaSettingParser;
import org.bbreak.excella.trans.tag.sheet2java.model.SheetToJavaParseInfo;
import org.bbreak.excella.trans.tag.sheet2java.model.SheetToJavaSettingInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SheetToJavaExecuter
implements SheetParseListener {
    protected static final String LNAME_TAG_PARAM_PREFIX = "(";
    protected static final String LNAME_TAG_PARAM_SUFFIX = ")";
    protected static final String TAG_PREFIX = "@";
    protected static final String TAG_LOGICAL_NAME_PREFIX = "@LNAME(";
    private List<SheetToJavaPropertyParser> customPropertyParsers = new ArrayList<SheetToJavaPropertyParser>();
    private List<SheetToJavaListener> sheetToJavaListeners = new ArrayList<SheetToJavaListener>();

    public void preParse(Sheet sheet, SheetParser sheetParser) {
    }

    public void postParse(Sheet sheet, SheetParser sheetParser, SheetData sheetData) throws ParseException {
        ArrayList<Object> results = new ArrayList<Object>();
        List tagParsers = sheetParser.getTagParsers();
        ArrayList<String> removeTags = new ArrayList<String>();
        ArrayList<String> targetTags = new ArrayList<String>();
        for (TagParser tagParser : tagParsers) {
            if (tagParser instanceof SheetToJavaParser) {
                targetTags.add(tagParser.getTag());
            }
            if (!(tagParser instanceof SheetToJavaSettingParser)) continue;
            removeTags.add(tagParser.getTag());
        }
        Workbook workbook = sheet.getWorkbook();
        for (String tag : targetTags) {
            List sheetInfoList = (List)sheetData.get(tag);
            if (sheetInfoList == null) continue;
            for (SheetToJavaParseInfo sheetInfo : sheetInfoList) {
                List allColumnInfoList = (List)sheetData.get(sheetInfo.getSettingTagName());
                ArrayList<SheetToJavaSettingInfo> targetColumnInfoList = new ArrayList<SheetToJavaSettingInfo>();
                for (SheetToJavaSettingInfo columnInfo : allColumnInfoList) {
                    if (!columnInfo.getSheetName().equals(sheetInfo.getSheetName())) continue;
                    targetColumnInfoList.add(columnInfo);
                }
                Sheet targetSheet = workbook.getSheet(sheetInfo.getSheetName());
                if (targetSheet == null) {
                    throw new ParseException(sheetInfo.getSheetNameCell(), "\u30b7\u30fc\u30c8[" + sheetInfo.getSheetName() + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
                }
                results.addAll(this.parseTargetSheet(targetSheet, sheetInfo, targetColumnInfoList));
            }
            sheetData.put(tag, results);
        }
        for (String removeTag : removeTags) {
            sheetData.remove((Object)removeTag);
        }
    }

    protected List<Object> parseTargetSheet(Sheet targetSheet, SheetToJavaParseInfo sheetInfo, List<SheetToJavaSettingInfo> targetColumnInfoList) throws ParseException {
        ArrayList<Object> results = new ArrayList<Object>();
        int logicalRowNum = sheetInfo.getLogicalNameRowNum() - 1;
        int valueStartRowNum = sheetInfo.getValueRowNum() - 1;
        int valueEndRowNum = targetSheet.getLastRowNum();
        HashMap<String, Integer> colLogicalNameMap = new HashMap<String, Integer>();
        Row row = targetSheet.getRow(logicalRowNum);
        if (row != null) {
            int firstColIdx = row.getFirstCellNum();
            short lastColIdx = row.getLastCellNum();
            for (int colIdx = firstColIdx; colIdx <= lastColIdx; ++colIdx) {
                Cell cell = row.getCell(colIdx);
                if (cell == null) continue;
                try {
                    String string = cell.getStringCellValue();
                    if (string.startsWith("-")) continue;
                    colLogicalNameMap.put(string, colIdx);
                    continue;
                }
                catch (Exception exception) {
                    throw new ParseException(cell, (Throwable)exception);
                }
            }
        }
        ArrayList classList = new ArrayList();
        HashMap settingInfoListMap = new HashMap();
        HashMap uniquePropertyListMap = new HashMap();
        for (SheetToJavaSettingInfo sheetToJavaSettingInfo : targetColumnInfoList) {
            ArrayList<String> uniquePropertyList;
            Class<?> clazz = sheetToJavaSettingInfo.getClazz();
            ArrayList<SheetToJavaSettingInfo> settingInfoList = (ArrayList<SheetToJavaSettingInfo>)settingInfoListMap.get(clazz);
            if (settingInfoList == null) {
                settingInfoList = new ArrayList<SheetToJavaSettingInfo>();
            }
            if ((uniquePropertyList = (ArrayList<String>)uniquePropertyListMap.get(clazz)) == null) {
                uniquePropertyList = new ArrayList<String>();
            }
            settingInfoList.add(sheetToJavaSettingInfo);
            if (sheetToJavaSettingInfo.isUnique()) {
                uniquePropertyList.add(sheetToJavaSettingInfo.getPropertyName());
            }
            if (!classList.contains(clazz)) {
                classList.add(clazz);
            }
            settingInfoListMap.put(clazz, settingInfoList);
            uniquePropertyListMap.put(clazz, uniquePropertyList);
        }
        for (Class clazz : classList) {
            ArrayList<Object> objList = new ArrayList<Object>();
            Object obj = null;
            try {
                for (int valueRowIdx = valueStartRowNum; valueRowIdx <= valueEndRowNum; ++valueRowIdx) {
                    List uniquePropertyList;
                    Row valueRow = targetSheet.getRow(valueRowIdx);
                    if (valueRow == null) continue;
                    boolean isProcessRow = true;
                    for (SheetToJavaListener propertyListener : this.sheetToJavaListeners) {
                        if (propertyListener.preProcessRow(valueRow)) continue;
                        isProcessRow = false;
                    }
                    if (!isProcessRow) continue;
                    obj = Class.forName(clazz.getName()).newInstance();
                    List settingInfoList = (List)settingInfoListMap.get(clazz);
                    for (SheetToJavaSettingInfo settingInfo : settingInfoList) {
                        String settingValueStr;
                        Object value;
                        String propertyName = settingInfo.getPropertyName();
                        Object settingValue = value = settingInfo.getValue();
                        Cell valueCell = null;
                        if (value instanceof String && (settingValueStr = (String)value).startsWith(TAG_PREFIX)) {
                            if (settingValueStr.startsWith(TAG_LOGICAL_NAME_PREFIX)) {
                                String logicalKey = TagUtil.getParam((String)settingValueStr, (String)LNAME_TAG_PARAM_PREFIX, (String)LNAME_TAG_PARAM_SUFFIX);
                                Integer logicalKeyCol = (Integer)colLogicalNameMap.get(logicalKey);
                                if (logicalKeyCol == null) {
                                    Cell errorCell = null;
                                    for (SheetToJavaSettingInfo columnInfo : targetColumnInfoList) {
                                        if (!columnInfo.getValue().equals(settingValueStr)) continue;
                                        errorCell = columnInfo.getValueCell();
                                    }
                                    throw new ParseException(errorCell, "\u8ad6\u7406\u540d\u30bf\u30b0\u30d1\u30e9\u30e1\u30fc\u30bf\u4e0d\u6b63:" + logicalKey);
                                }
                                valueCell = valueRow.getCell(logicalKeyCol.intValue());
                                if (valueCell != null) {
                                    Class propertyClass = PropertyUtils.getPropertyType(obj, (String)settingInfo.getPropertyName());
                                    try {
                                        settingValue = PoiUtil.getCellValue((Cell)valueCell, (Class)propertyClass);
                                    }
                                    catch (RuntimeException e) {
                                        throw new ParseException(valueCell, "\u5024\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f(" + propertyClass + LNAME_TAG_PARAM_SUFFIX, (Throwable)e);
                                    }
                                } else {
                                    settingValue = null;
                                    valueCell = null;
                                }
                            } else {
                                this.parseCustomProperty(valueCell, colLogicalNameMap, obj, valueRow, settingValueStr);
                                continue;
                            }
                        }
                        try {
                            for (SheetToJavaListener propertyListener : this.sheetToJavaListeners) {
                                propertyListener.preSetProperty(valueCell, obj, propertyName, settingValue);
                            }
                            PropertyUtils.setProperty(obj, (String)propertyName, (Object)settingValue);
                            for (SheetToJavaListener propertyListener : this.sheetToJavaListeners) {
                                propertyListener.postSetProperty(valueCell, obj, propertyName, settingValue);
                            }
                        }
                        catch (ParseException parseEx) {
                            throw parseEx;
                        }
                        catch (RuntimeException e) {
                            throw new ParseException(valueCell, "\u5024\u306e\u8a2d\u5b9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f(" + propertyName + "=" + settingValue + "[" + settingValue.getClass().getCanonicalName() + "]" + LNAME_TAG_PARAM_SUFFIX, (Throwable)e);
                        }
                    }
                    for (SheetToJavaListener propertyListener : this.sheetToJavaListeners) {
                        if (propertyListener.postProcessRow(valueRow, obj)) continue;
                        isProcessRow = false;
                    }
                    if (!isProcessRow || this.isDuplicateObj(obj, objList, uniquePropertyList = (List)uniquePropertyListMap.get(clazz))) continue;
                    objList.add(obj);
                }
                results.addAll(objList);
            }
            catch (ParseException parseEx) {
                throw parseEx;
            }
            catch (Exception e) {
                throw new ParseException(e.toString());
            }
        }
        return results;
    }

    private void parseCustomProperty(Cell valueCell, Map<String, Integer> colLogicalNameMap, Object obj, Row valueRow, String tag) throws ParseException {
        for (SheetToJavaPropertyParser propertyParser : this.customPropertyParsers) {
            if (!propertyParser.isParse(tag)) continue;
            Map paramMap = TagUtil.getParams((String)tag);
            Set paramKeys = paramMap.keySet();
            HashMap<String, Object> paramValueMap = new HashMap<String, Object>();
            HashMap<String, Cell> paramCellMap = new HashMap<String, Cell>();
            for (String paramKey : paramKeys) {
                String paramValue = (String)paramMap.get(paramKey);
                if (paramValue.startsWith(TAG_LOGICAL_NAME_PREFIX)) {
                    String logicalMapKey = TagUtil.getParam((String)paramValue, (String)LNAME_TAG_PARAM_PREFIX, (String)LNAME_TAG_PARAM_SUFFIX);
                    Integer logicalKeyCol = colLogicalNameMap.get(logicalMapKey);
                    Cell cell = valueRow.getCell(logicalKeyCol.intValue());
                    Object cellValue = PoiUtil.getCellValue((Cell)cell);
                    paramValueMap.put(paramKey, cellValue);
                    paramCellMap.put(paramKey, cell);
                    continue;
                }
                paramValueMap.put(paramKey, paramValue);
            }
            propertyParser.parse(obj, paramCellMap, paramValueMap);
        }
    }

    private boolean isDuplicateObj(Object targetObj, List<Object> objList, List<String> uniquePropertyList) throws Exception {
        boolean result = false;
        if (objList.size() == 0) {
            return false;
        }
        if (uniquePropertyList.size() == 0) {
            return false;
        }
        for (Object obj : objList) {
            boolean isDuplicate = true;
            for (String propertyName : uniquePropertyList) {
                Object checkProperty = PropertyUtils.getProperty((Object)targetObj, (String)propertyName);
                Object property = PropertyUtils.getProperty((Object)obj, (String)propertyName);
                if (property == null) {
                    if (checkProperty == null) continue;
                    isDuplicate = false;
                    continue;
                }
                if (property.equals(checkProperty)) continue;
                isDuplicate = false;
            }
            if (!isDuplicate) continue;
            result = true;
            break;
        }
        return result;
    }

    public void addPropertyParser(SheetToJavaPropertyParser parser) {
        this.customPropertyParsers.add(parser);
    }

    public void clearPropertyParsers() {
        this.customPropertyParsers.clear();
    }

    public void addSheetToJavaListener(SheetToJavaListener listener) {
        this.sheetToJavaListeners.add(listener);
    }

    public void clearSheetToJavaListeners() {
        this.sheetToJavaListeners.clear();
    }
}

