/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Trans - Excelt@C𗘗pf[^ڍsxc[
 *
 * $Id: SheetToJavaListener.java 56 2009-11-17 09:19:55Z akira-yokoi $
 * $Revision: 56 $
 *
 * This file is part of ExCella Trans.
 *
 * ExCella Trans is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Trans is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Trans.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.trans.tag.sheet2java;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.bbreak.excella.core.exception.ParseException;

/**
 * SheetToJavapvpeBݒ菈Xi
 * vpeBݒ̑OɌĂ΂郁\bhAvpeBݒOɒľ؏
 * sꍇɗpB
 * 
 * @since 1.1
 */
public interface SheetToJavaListener {

    /**
     * sOɔCӂ̏
     * falseԂƑΏۍs͏ΏۊOƂ݂ȂAXLbv
     * 
     * @param row s
     * @return true=ΏہAfalse=ΏۊO
     */
    boolean preProcessRow( Row row) throws ParseException;
    
    /**
     * sɔCӂ̏
     * falseԂƑΏۍšʂ͖Ƃ݂ȂAXLbv
     * 
     * @param row s
     * @param obj sʂ̃IuWFNg
     * @return true=ΏہAfalse=ΏۊO
     */
    boolean postProcessRow( Row row, Object obj) throws ParseException;
    
    /**
     * vpeBݒOɔCӂ̏
     * 
     * @param valueCell l̓Z
     * @param obj vpeBݒΏۃIuWFNg
     * @param propertyName vpeB
     * @param value l
     * @throws ParseException ؃G[̏ꍇ
     */
    void preSetProperty( Cell valueCell, Object obj, String propertyName, Object value) throws ParseException;
    
    /**
     * vpeBݒOɔCӂ̏
     * 
     * @param valueCell l̓Z
     * @param obj vpeBݒΏۃIuWFNg
     * @param propertyName vpeB
     * @param value l
     * @throws ParseException ؃G[̏ꍇ
     */
    void postSetProperty( Cell valueCell, Object obj, String propertyName, Object value) throws ParseException;
}
