/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Trans - Excelt@C𗘗pf[^ڍsxc[
 *
 * $Id: SqlParser.java 17 2009-06-24 04:59:23Z yuta-takahashi $
 * $Revision: 17 $
 *
 * This file is part of ExCella Trans.
 *
 * ExCella Trans is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Trans is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Trans.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.trans.tag.sheet2sql;

import java.util.ArrayList;
import java.util.List;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.tag.excel2java.ListParser;

/**
 * V[g͂ASQL<BR>
 * List&lt;String&gt;ŕԋpp[T
 * 
 * @since 1.0
 */
public class SqlParser extends ListParser {

    /**
     * ftHg^O
     */
    public static final String DEFAULT_TAG = "@Sql";

    /**
     * SQLړ
     */
    protected static final String SQL_PREFIX = "";

    /**
     * SQLڔ
     */
    protected static final String SQL_SUFFIX = ";";

    /**
     * RXgN^
     */
    public SqlParser() {
        super( DEFAULT_TAG);
    }

    /**
     * RXgN^
     * 
     * @param tag ^O
     */
    public SqlParser( String tag) {
        super( tag);
    }

    /**
     * p[X
     * 
     * @param sheet ΏۃV[g
     * @param tagCell ^O`ꂽZ
     * @param data TransProcessorprocessBook, processSheet\bh<BR> 
     *              nꍇTagParser܂ňp鏈f[^<BR>
     * @return p[X
     * @throws ParseException p[XO
     */
    @Override
    public List<String> parse( Sheet sheet, Cell tagCell, Object data) throws ParseException {

        return parse( sheet, tagCell, data, SQL_PREFIX, SQL_SUFFIX);
    }

    /**
     * ړAڔt^̃XgԂB
     * 
     * @param sheet V[g
     * @param tagCell ^OZ
     * @param data TransProcessorprocessBook, processSheet\bh<BR> 
     *              nꍇTagParser.parse\bh܂ňp鏈f[^<BR>
     * @param prefix ړ
     * @param suffix ڔ
     * @return SQL̃Xg
     * @throws ParseException p[XO
     */
    public List<String> parse( Sheet sheet, Cell tagCell, Object data, String prefix, String suffix) throws ParseException {

        List<?> objList = super.parse( sheet, tagCell, data);
        List<String> resultList = new ArrayList<String>();

        for ( Object obj : objList) {

            if ( obj == null) {
                continue;
            }

            String sql = obj.toString();
            StringBuilder strBuild = new StringBuilder();

            // ڔt^
            strBuild.append( prefix);

            strBuild.append( sql);

            // ڔt^
            strBuild.append( suffix);

            sql = strBuild.toString();
            resultList.add( sql);
        }

        return resultList;
    }
}
