/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.core;

import java.util.Calendar;
import java.util.Date;
import org.apache.poi.ss.formula.FormulaParseException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class CellClone
implements Cell {
    private int rowIndex;
    private int columnIndex;
    private CellStyle cellStyle;
    private int cellType;
    private Comment cellComment;
    private Row row;
    private Sheet sheet;
    private Hyperlink hyperlink;
    private boolean booleanCellValue;
    private String cellFormula;
    private Date dateCellValue;
    private byte errorCellValue;
    private double numericCellValue;
    private RichTextString richStringCellValue;

    public CellClone(Cell cell) {
        this.rowIndex = cell.getRowIndex();
        this.columnIndex = cell.getColumnIndex();
        this.cellStyle = cell.getCellStyle();
        this.cellType = cell.getCellType();
        this.cellComment = cell.getCellComment();
        this.row = cell.getRow();
        this.sheet = cell.getSheet();
        this.hyperlink = cell.getHyperlink();
        switch (this.cellType) {
            case 0: 
            case 2: 
            case 3: {
                this.numericCellValue = cell.getNumericCellValue();
                this.dateCellValue = cell.getDateCellValue();
            }
        }
        switch (this.cellType) {
            case 1: 
            case 2: 
            case 3: {
                this.richStringCellValue = cell.getRichStringCellValue();
            }
        }
        switch (this.cellType) {
            case 2: 
            case 3: 
            case 4: {
                this.booleanCellValue = cell.getBooleanCellValue();
            }
        }
        switch (this.cellType) {
            case 2: {
                this.cellFormula = cell.getCellFormula();
            }
        }
        switch (this.cellType) {
            case 5: {
                this.errorCellValue = cell.getErrorCellValue();
            }
        }
    }

    public CellRangeAddress getArrayFormulaRange() {
        throw new IllegalStateException("CellClone is not support getArrayFormulaRange().");
    }

    public boolean getBooleanCellValue() {
        return this.booleanCellValue;
    }

    public int getCachedFormulaResultType() {
        throw new IllegalStateException("CellClone is not support getCachedFormulaResultType().");
    }

    public Comment getCellComment() {
        return this.cellComment;
    }

    public String getCellFormula() {
        return this.cellFormula;
    }

    public CellStyle getCellStyle() {
        return this.cellStyle;
    }

    public int getCellType() {
        return this.cellType;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public Date getDateCellValue() {
        return this.dateCellValue;
    }

    public byte getErrorCellValue() {
        return this.errorCellValue;
    }

    public Hyperlink getHyperlink() {
        return this.hyperlink;
    }

    public double getNumericCellValue() {
        return this.numericCellValue;
    }

    public RichTextString getRichStringCellValue() {
        return this.richStringCellValue;
    }

    public Row getRow() {
        return this.row;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public String getStringCellValue() {
        RichTextString str = this.getRichStringCellValue();
        return str == null ? null : str.getString();
    }

    public boolean isPartOfArrayFormulaGroup() {
        throw new IllegalStateException("CellClone is not support isPartOfArrayFormulaGroup().");
    }

    public void removeCellComment() {
        throw new IllegalStateException("CellClone is not support removeCellComment().");
    }

    public void setAsActiveCell() {
        throw new IllegalStateException("CellClone is not support setAsActiveCell().");
    }

    public void setCellComment(Comment comment) {
        throw new IllegalStateException("CellClone is not support setCellComment(Comment comment).");
    }

    public void setCellErrorValue(byte value) {
        throw new IllegalStateException("CellClone is not support setCellErrorValue(byte value).");
    }

    public void setCellFormula(String formula) throws FormulaParseException {
        throw new IllegalStateException("CellClone is not support setCellFormula(String formula).");
    }

    public void setCellStyle(CellStyle style) {
        throw new IllegalStateException("CellClone is not support setCellStyle(CellStyle style).");
    }

    public void setCellType(int cellType) {
        throw new IllegalStateException("CellClone is not support setCellType(int cellType).");
    }

    public void setCellValue(double value) {
        throw new IllegalStateException("CellClone is not support setCellValue(double value).");
    }

    public void setCellValue(Date value) {
        throw new IllegalStateException("CellClone is not support setCellValue(Date value).");
    }

    public void setCellValue(Calendar value) {
        throw new IllegalStateException("CellClone is not support setCellValue(Calendar value).");
    }

    public void setCellValue(RichTextString value) {
        throw new IllegalStateException("CellClone is not support setCellValue(RichTextString value).");
    }

    public void setCellValue(String value) {
        throw new IllegalStateException("CellClone is not support setCellValue(String value).");
    }

    public void setCellValue(boolean value) {
        throw new IllegalStateException("CellClone is not support setCellValue(boolean value).");
    }

    public void setHyperlink(Hyperlink link) {
        throw new IllegalStateException("CellClone is not support setHyperlink(Hyperlink link).");
    }
}

