/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.bbreak.excella.core.SheetData;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.tag.TagParser;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.core.util.TagUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SheetParser {
    protected static final String PARAM_RESULT_KEY = "ResultKey";
    protected static final String PARAM_LAST_TAG = "LastTag";
    private static Log log = LogFactory.getLog(SheetParser.class);
    private List<TagParser<?>> tagParsers = new ArrayList();

    public SheetData parseSheet(Sheet sheet, Object data) throws ParseException {
        int firstRowNum;
        String sheetName = PoiUtil.getSheetName(sheet);
        SheetData sheetData = new SheetData(sheetName);
        for (int rowCnt = firstRowNum = sheet.getFirstRowNum(); rowCnt <= sheet.getLastRowNum(); ++rowCnt) {
            Row row = sheet.getRow(rowCnt);
            if (row == null || row == null) continue;
            for (int columnIdx = 0; columnIdx < row.getLastCellNum(); ++columnIdx) {
                Cell cell = row.getCell(columnIdx);
                if (cell == null || !this.parseCell(sheet, data, sheetData, cell, row, columnIdx)) continue;
                return sheetData;
            }
        }
        return sheetData;
    }

    private boolean parseCell(Sheet sheet, Object data, SheetData sheetData, Cell cell, Row row, int columnIdx) throws ParseException {
        for (TagParser<?> parser : this.tagParsers) {
            if (!parser.isParse(sheet, cell)) continue;
            String strCellValue = cell.getStringCellValue();
            Map<String, String> paramDef = TagUtil.getParams(strCellValue);
            Object result = parser.parse(sheet, cell, data);
            if (result != null) {
                String resultKey = parser.getTag();
                if (paramDef.containsKey(PARAM_RESULT_KEY)) {
                    resultKey = paramDef.get(PARAM_RESULT_KEY);
                }
                sheetData.put(resultKey, result);
            }
            if (log.isInfoEnabled()) {
                StringBuilder resultBuf = new StringBuilder(strCellValue + "\u306e\u51e6\u7406\u7d50\u679c:");
                if (result instanceof Map) {
                    Map mapResult = (Map)result;
                    Set keyset = mapResult.keySet();
                    for (Object key : keyset) {
                        resultBuf.append("[" + key + ":" + mapResult.get(key) + "]");
                    }
                } else if (result instanceof Collection) {
                    Collection listResult = (Collection)result;
                    resultBuf.append(listResult.getClass() + " Size=" + listResult.size());
                } else {
                    resultBuf.append(result);
                }
                log.info((Object)resultBuf.toString());
            }
            if (paramDef.containsKey(PARAM_LAST_TAG)) {
                String strLastTag = paramDef.get(PARAM_LAST_TAG);
                try {
                    if (Boolean.parseBoolean(strLastTag)) {
                        return true;
                    }
                }
                catch (Exception e) {
                    throw new ParseException(cell);
                }
            }
            if ((cell = row.getCell(columnIdx)) == null || cell.getCellType() != 1 || strCellValue.equals(cell.getStringCellValue()) || !this.parseCell(sheet, data, sheetData, cell, row, columnIdx)) break;
            return true;
        }
        return false;
    }

    public void addTagParser(TagParser<?> tagParser) {
        this.tagParsers.add(tagParser);
    }

    public List<TagParser<?>> getTagParsers() {
        return this.tagParsers;
    }
}

