/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.trans.tag.sheet2java;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.tag.TagParser;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.core.util.TagUtil;
import org.bbreak.excella.trans.tag.sheet2java.model.SheetToJavaSettingInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SheetToJavaSettingParser
extends TagParser<List<SheetToJavaSettingInfo>> {
    public static final String DEFAULT_TAG = "@SheetToJavaSetting";
    protected static final String PARAM_DATA_ROW_FROM = "DataRowFrom";
    protected static final String PARAM_DATA_ROW_TO = "DataRowTo";
    protected static final int DEFAULT_DATA_ROW_FROM_ADJUST = 2;
    protected static final String UNIQUE_PROPERTY_MARK = "\u25cb";

    public SheetToJavaSettingParser() {
        super(DEFAULT_TAG);
    }

    public SheetToJavaSettingParser(String tag) {
        super(tag);
    }

    public List<SheetToJavaSettingInfo> parse(Sheet sheet, Cell tagCell, Object data) throws ParseException {
        int tagRowIdx = tagCell.getRowIndex();
        int tagColIdx = tagCell.getColumnIndex();
        int valueRowToIdx = sheet.getLastRowNum();
        try {
            Map paramDef = TagUtil.getParams((String)tagCell.getStringCellValue());
            int valueRowFromIdx = TagUtil.adjustValue((int)tagRowIdx, (Map)paramDef, (String)PARAM_DATA_ROW_FROM, (int)2);
            if (valueRowFromIdx < 0 || valueRowFromIdx > sheet.getLastRowNum()) {
                throw new ParseException(tagCell, "\u30d1\u30e9\u30e1\u30fc\u30bf\u5024\u4e0d\u6b63\uff1aDataRowFrom");
            }
            if ((valueRowToIdx = TagUtil.adjustValue((int)tagRowIdx, (Map)paramDef, (String)PARAM_DATA_ROW_TO, (int)(valueRowToIdx - tagRowIdx))) > sheet.getLastRowNum() || valueRowToIdx < 0) {
                throw new ParseException(tagCell, "\u30d1\u30e9\u30e1\u30fc\u30bf\u5024\u4e0d\u6b63\uff1aDataRowTo");
            }
            if (valueRowFromIdx > valueRowToIdx) {
                throw new ParseException(tagCell, "\u30d1\u30e9\u30e1\u30fc\u30bf\u5024\u4e0d\u6b63\uff1aDataRowFrom,DataRowTo");
            }
        }
        catch (Exception e) {
            if (e instanceof ParseException) {
                throw (ParseException)((Object)e);
            }
            throw new ParseException(tagCell, (Throwable)e);
        }
        ArrayList<SheetToJavaSettingInfo> sheetSettingInfoList = new ArrayList<SheetToJavaSettingInfo>();
        int sheetNameColIdx = tagColIdx++;
        int valueColIdx = tagColIdx++;
        int classColIdx = tagColIdx++;
        int propertyNameColIdx = tagColIdx++;
        int uniqueColIdx = tagColIdx++;
        Workbook workbook = sheet.getWorkbook();
        for (int rowNum = valueRowFromIdx; rowNum <= valueRowToIdx; ++rowNum) {
            String valueStr;
            Row row = sheet.getRow(rowNum);
            if (row == null) continue;
            Cell sheetNameCell = row.getCell(sheetNameColIdx);
            Cell valueCell = row.getCell(valueColIdx);
            Cell classCell = row.getCell(classColIdx);
            Cell propertyNameCell = row.getCell(propertyNameColIdx);
            Cell uniqueCell = row.getCell(uniqueColIdx);
            if (sheetNameCell == null && valueCell == null && classCell == null && propertyNameCell == null && uniqueCell == null || sheetNameCell == null || sheetNameCell.getStringCellValue() == null || "".equals(sheetNameCell.getStringCellValue())) continue;
            Cell requiredErrorCell = null;
            if (classCell == null) {
                requiredErrorCell = row.createCell(classColIdx);
            }
            if (requiredErrorCell != null) {
                throw new ParseException(requiredErrorCell, "\u5fc5\u9808\u30bb\u30eb\u304cnull\u3067\u3059");
            }
            SheetToJavaSettingInfo settingInfo = new SheetToJavaSettingInfo();
            String sheetName = sheetNameCell.getStringCellValue();
            if (workbook.getSheet(sheetName) == null) {
                throw new ParseException(sheetNameCell, "\u30b7\u30fc\u30c8[" + sheetName + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
            settingInfo.setSheetName(sheetName);
            settingInfo.setSheetNameCell(sheetNameCell);
            try {
                settingInfo.setClazz(Class.forName(classCell.getStringCellValue()));
                settingInfo.setClazzCell(classCell);
            }
            catch (ClassNotFoundException e) {
                throw new ParseException(classCell, (Throwable)e);
            }
            Object value = PoiUtil.getCellValue((Cell)valueCell);
            settingInfo.setValueCell(valueCell);
            boolean isValueTag = false;
            boolean isValueLogicalNameTag = false;
            if (value instanceof String && (valueStr = (String)value).startsWith("@")) {
                isValueTag = true;
                if (valueStr.startsWith("@LNAME(")) {
                    isValueLogicalNameTag = true;
                }
            }
            if (!isValueTag || isValueLogicalNameTag) {
                Cell requiredErrorCell2 = null;
                if (propertyNameCell == null) {
                    requiredErrorCell2 = row.createCell(propertyNameColIdx);
                }
                if (requiredErrorCell2 != null) {
                    throw new ParseException(requiredErrorCell2, "\u5fc5\u9808\u30bb\u30eb\u304cnull\u3067\u3059");
                }
                settingInfo.setPropertyName(propertyNameCell.getStringCellValue());
                settingInfo.setPropertyNameCell(propertyNameCell);
                Class propertyClass = null;
                try {
                    Object obj = settingInfo.getClazz().newInstance();
                    propertyClass = PropertyUtils.getPropertyType(obj, (String)settingInfo.getPropertyName());
                }
                catch (Exception e) {
                    throw new ParseException(propertyNameCell, (Throwable)e);
                }
                if (propertyClass == null) {
                    throw new ParseException(propertyNameCell, "\u30d7\u30ed\u30d1\u30c6\u30a3\u4e0d\u6b63:" + settingInfo.getPropertyName());
                }
                if (uniqueCell != null && uniqueCell.getStringCellValue() != null && uniqueCell.getStringCellValue().equals(UNIQUE_PROPERTY_MARK)) {
                    settingInfo.setUnique(true);
                    settingInfo.setUniqueCell(uniqueCell);
                }
            } else {
                try {
                    TagUtil.getParams((String)((String)value));
                }
                catch (Exception e) {
                    throw new ParseException(valueCell, (Throwable)e);
                }
            }
            boolean checkTypeFlag = false;
            if (value instanceof String) {
                if (!isValueTag) {
                    checkTypeFlag = true;
                }
            } else if (value != null) {
                checkTypeFlag = true;
            }
            if (checkTypeFlag) {
                try {
                    Object obj = settingInfo.getClazz().newInstance();
                    Class propertyClass = PropertyUtils.getPropertyType(obj, (String)settingInfo.getPropertyName());
                    value = PoiUtil.getCellValue((Cell)valueCell, (Class)propertyClass);
                }
                catch (Exception e) {
                    throw new ParseException(valueCell, (Throwable)e);
                }
            }
            settingInfo.setValue(value);
            sheetSettingInfoList.add(settingInfo);
        }
        return sheetSettingInfoList;
    }
}

