/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Trans - Excelt@C𗘗pf[^ڍsxc[
 *
 * $Id: UserOrgDataTransExecuter.java 38 2009-07-02 09:17:36Z yuta-takahashi $
 * $Revision: 38 $
 *
 * This file is part of ExCella Trans.
 *
 * ExCella Trans is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Trans is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Trans.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.trans.samples;

import java.net.URL;
import java.net.URLDecoder;
import java.util.List;

import org.bbreak.excella.core.BookData;
import org.bbreak.excella.core.SheetData;
import org.bbreak.excella.core.exporter.book.ConsoleExporter;
import org.bbreak.excella.core.handler.DebugErrorHandler;
import org.bbreak.excella.trans.processor.TransProcessor;

/**
 * f[^ڍsTvNX
 * 
 * @since 1.0
 */
public class UserOrgDataTransExecuter {

    @SuppressWarnings( {"unchecked", "unused" })
    public static void main( String[] args) throws Exception {

        // NX̏ꏊǂݍރt@C̃pX擾
        String filename = "ڍsf[^Tv.xls";
        URL url = UserOrgDataTransExecuter.class.getResource( filename);
        String filePath = URLDecoder.decode( url.getFile(), "UTF-8");

        // vZbT
        TransProcessor processor = new TransProcessor( filePath);

        // G[nhݒ
        processor.setErrorHandler( new DebugErrorHandler());

        // ubNGNX|[^ǉ
        processor.addBookExporter( new ConsoleExporter());
        
        // vZXs
        BookData bookData = processor.processBook();

        // V[gXg̎擾
        List<String> sheetNames = processor.getSheetNames();

        // V[gPʂŃ[v
        for ( String sheetName : sheetNames) {

            if ( !sheetName.startsWith( TransProcessor.COMMENT_PREFIX)) {
                // RgAEgĂȂV[g̏ꍇ

                // V[gf[^̎擾
                SheetData sheetData = bookData.getSheetData( sheetName);

                // ^OXg̎擾
                List<String> tagNames = sheetData.getKeyList();

                // ^OXgŃ[v
                for ( String tagName : tagNames) {

                    if ( processor.isDefaultSqlTag( tagName)) {
                        // ʂSQL̏ꍇ

                        List<String> sqlList = ( List<String>) sheetData.get( tagName);

                        /* SQL̎sLq */

                    } else {
                        // ȊȌꍇ
                        
                        List<Object> entityList = ( List<Object>) sheetData.get( tagName);
                        
                        /* GeBeB̏Lq */

                    }
                }
            }
        }
    }
}
