/*
 * Decompiled with CFR 0.152.
 */
package net.w_horse.excelpojo.excel;

import java.lang.annotation.Annotation;
import net.w_horse.excelpojo.ExcelPOJOBridge;
import net.w_horse.excelpojo.annotation.ExcelPOJOAnnotationParser;
import net.w_horse.excelpojo.excel.CellNotFoundException;
import net.w_horse.excelpojo.excel.ExcelUtils;
import net.w_horse.excelpojo.xml.ExcelPOJOXmlParser;
import net.w_horse.excelpojo.xml.tag.Use;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.w3c.dom.Element;

public abstract class AbstractCellSeeker {
    private ExcelPOJOBridge excelPOJOBridge;
    private String use = Use.NONE.getValue();

    public abstract void set(Element var1, ExcelPOJOXmlParser var2);

    public abstract void set(Annotation var1, ExcelPOJOAnnotationParser var2) throws ClassNotFoundException, LinkageError;

    public abstract boolean verify() throws IllegalArgumentException;

    public abstract Object seekCellValue(HSSFSheet var1, Class<?> var2) throws ClassNotFoundException, LinkageError, CellNotFoundException;

    protected abstract Offset seekCellPosition(HSSFSheet var1) throws CellNotFoundException;

    protected abstract Offset seekCellPosition(HSSFSheet var1, Offset var2, Offset var3) throws CellNotFoundException;

    public abstract void setValue(HSSFSheet var1, Object var2) throws CellNotFoundException;

    protected abstract void setValue(HSSFSheet var1, Offset var2, Offset var3, Object var4) throws CellNotFoundException;

    protected <T> T getCellValue(HSSFSheet hSSFSheet, Offset offset, Class<T> clazz) {
        return this.getCellValue(hSSFSheet, offset, new Offset(), clazz);
    }

    protected <T> T getCellValue(HSSFSheet hSSFSheet, Offset offset, Offset offset2, Class<T> clazz) {
        return this.getCellValue(this.getCell(hSSFSheet, offset, offset2), clazz);
    }

    public <T> T getCellValue(HSSFCell hSSFCell, Class<T> clazz) {
        return ExcelUtils.getCellValue(hSSFCell, clazz);
    }

    protected HSSFCell createCell(HSSFSheet hSSFSheet, Offset offset, Offset offset2) {
        HSSFCell hSSFCell;
        HSSFRow hSSFRow = hSSFSheet.getRow(offset.rowIndex + offset2.rowIndex);
        if (hSSFRow == null) {
            hSSFRow = hSSFSheet.createRow(offset.rowIndex + offset2.rowIndex);
        }
        if ((hSSFCell = hSSFRow.getCell(offset.colIndex + offset2.colIndex)) == null) {
            hSSFCell = hSSFRow.createCell(offset.colIndex + offset2.colIndex);
        }
        return hSSFCell;
    }

    protected HSSFCell getCell(HSSFSheet hSSFSheet, Offset offset) {
        return this.getCell(hSSFSheet, offset, new Offset());
    }

    protected HSSFCell getCell(HSSFSheet hSSFSheet, Offset offset, Offset offset2) {
        if (offset == null) {
            return null;
        }
        return this.createCell(hSSFSheet, offset, offset2);
    }

    protected void setCellValue(HSSFCell hSSFCell, Object object) {
        ExcelUtils.setCellValue(hSSFCell, object);
    }

    public void setExcelPOJOBridge(ExcelPOJOBridge excelPOJOBridge) {
        this.excelPOJOBridge = excelPOJOBridge;
    }

    public ExcelPOJOBridge getExcelPOJOBridge() {
        return this.excelPOJOBridge;
    }

    public void setUse(String string) {
        this.use = string;
    }

    public String getUse() {
        return this.use;
    }

    protected class Offset {
        public int rowIndex = 0;
        public int colIndex = 0;

        public Offset() {
        }

        public Offset(Offset offset) {
            this.rowIndex = offset.rowIndex;
            this.colIndex = offset.colIndex;
        }

        public Offset(int n, int n2) {
            this.rowIndex = n;
            this.colIndex = n2;
        }

        public Offset add(Offset offset) {
            this.rowIndex += offset.rowIndex;
            this.colIndex += offset.colIndex;
            return this;
        }

        public Offset negate() {
            return new Offset(-this.rowIndex, -this.colIndex);
        }
    }
}

