/*
 * Decompiled with CFR 0.152.
 */
package net.w_horse.excelpojo.excel;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.text.DateFormat;
import java.util.Date;
import net.w_horse.excelpojo.bean.Utils;
import net.w_horse.excelpojo.excel.CellDateFormat;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormatter;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.ss.usermodel.Cell;
import org.springframework.util.ReflectionUtils;

public class ExcelUtils {
    public static Object getCellValue(HSSFCell hSSFCell) {
        if (hSSFCell == null) {
            return null;
        }
        switch (hSSFCell.getCellType()) {
            case 3: {
                return "";
            }
            case 1: {
                return hSSFCell.getRichStringCellValue().getString();
            }
            case 0: {
                if (HSSFDateUtil.isCellDateFormatted((Cell)hSSFCell) || CellDateFormat.contains(hSSFCell.getCellStyle().getDataFormat())) {
                    return ExcelUtils.getDateType(hSSFCell);
                }
                return ExcelUtils.getNumericType(hSSFCell);
            }
            case 4: {
                return hSSFCell.getBooleanCellValue();
            }
            case 2: {
                return ExcelUtils.getFormulaType(hSSFCell);
            }
        }
        return "";
    }

    public static <T> T getCellValue(HSSFCell hSSFCell, Class<T> clazz) {
        Object object;
        if (hSSFCell == null) {
            return (T)Utils.convertIfNecessary(null, clazz);
        }
        switch (hSSFCell.getCellType()) {
            case 3: {
                object = "";
                break;
            }
            case 1: {
                object = hSSFCell.getRichStringCellValue().getString();
                break;
            }
            case 0: {
                if (HSSFDateUtil.isCellDateFormatted((Cell)hSSFCell) || CellDateFormat.contains(hSSFCell.getCellStyle().getDataFormat())) {
                    object = ExcelUtils.getDateType(hSSFCell, clazz);
                    break;
                }
                if (clazz.equals(String.class)) {
                    HSSFDataFormatter hSSFDataFormatter = new HSSFDataFormatter();
                    String string = hSSFDataFormatter.formatCellValue((Cell)hSSFCell);
                    if (string.endsWith("_ ")) {
                        string = string.substring(0, string.length() - 2);
                    }
                    return (T)string.trim();
                }
                object = ExcelUtils.getNumericType(hSSFCell);
                break;
            }
            case 4: {
                object = hSSFCell.getBooleanCellValue();
                break;
            }
            case 2: {
                object = ExcelUtils.getFormulaType(hSSFCell, clazz);
                break;
            }
            default: {
                object = "";
            }
        }
        return (T)Utils.convertIfNecessary(object, clazz);
    }

    private static <T> T getFormulaType(HSSFCell hSSFCell, Class<T> clazz) {
        try {
            HSSFRichTextString hSSFRichTextString = hSSFCell.getRichStringCellValue();
            return (T)hSSFRichTextString.getString();
        }
        catch (Exception exception) {
            if (HSSFDateUtil.isCellDateFormatted((Cell)hSSFCell) || CellDateFormat.contains(hSSFCell.getCellStyle().getDataFormat())) {
                return ExcelUtils.getDateType(hSSFCell, clazz);
            }
            if (clazz.equals(String.class)) {
                return (T)ExcelUtils.getNumericTypeString(hSSFCell);
            }
            return (T)ExcelUtils.getNumericType(hSSFCell);
        }
    }

    private static Object getFormulaType(HSSFCell hSSFCell) {
        try {
            HSSFRichTextString hSSFRichTextString = hSSFCell.getRichStringCellValue();
            return hSSFRichTextString.getString();
        }
        catch (Exception exception) {
            if (HSSFDateUtil.isCellDateFormatted((Cell)hSSFCell) || CellDateFormat.contains(hSSFCell.getCellStyle().getDataFormat())) {
                return ExcelUtils.getDateType(hSSFCell);
            }
            return ExcelUtils.getNumericType(hSSFCell);
        }
    }

    private static <T> T getDateType(HSSFCell hSSFCell, Class<T> clazz) {
        if (clazz.equals(String.class)) {
            return (T)ExcelUtils.getDateTypeString(hSSFCell);
        }
        return (T)ExcelUtils.getDateType(hSSFCell);
    }

    private static Date getDateType(HSSFCell hSSFCell) {
        return hSSFCell.getDateCellValue();
    }

    private static String getDateTypeString(HSSFCell hSSFCell) {
        HSSFCellStyle hSSFCellStyle = hSSFCell.getCellStyle();
        Date date = ExcelUtils.getDateType(hSSFCell);
        DateFormat dateFormat = CellDateFormat.getFormt(hSSFCellStyle.getDataFormat()).getDateFormat();
        return dateFormat.format(date);
    }

    private static String getNumericTypeString(HSSFCell hSSFCell) {
        return String.valueOf(ExcelUtils.getNumericType(hSSFCell));
    }

    private static Object getNumericType(HSSFCell hSSFCell) {
        BigDecimal bigDecimal = new BigDecimal(hSSFCell.getNumericCellValue(), new MathContext(17));
        try {
            BigInteger bigInteger = bigDecimal.toBigIntegerExact();
            if (bigInteger.compareTo(BigInteger.valueOf(bigInteger.intValue())) == 0) {
                return bigInteger.intValue();
            }
            return bigInteger;
        }
        catch (ArithmeticException arithmeticException) {
            return hSSFCell.getNumericCellValue();
        }
    }

    public static void setCellValue(HSSFCell hSSFCell, Object object) {
        Class<Object> clazz;
        if (hSSFCell == null) {
            return;
        }
        if (object == null) {
            object = "";
        }
        if ((clazz = object.getClass()).equals(Integer.TYPE) || clazz.equals(Double.TYPE) || clazz.equals(Short.TYPE) || clazz.equals(Long.TYPE) || clazz.equals(Float.TYPE)) {
            clazz = Double.TYPE;
        }
        try {
            ReflectionUtils.invokeMethod((Method)hSSFCell.getClass().getDeclaredMethod("setCellValue", clazz), (Object)hSSFCell, (Object[])new Object[]{object});
        }
        catch (NoSuchMethodException noSuchMethodException) {
            hSSFCell.setCellValue(String.valueOf(object));
        }
    }
}

