/*
 * Decompiled with CFR 0.152.
 */
package net.w_horse.excelpojo.excel;

import java.lang.annotation.Annotation;
import net.w_horse.excelpojo.annotation.ExcelPOJOAnnotationParser;
import net.w_horse.excelpojo.excel.AbstractCellSeeker;
import net.w_horse.excelpojo.excel.CellNotFoundException;
import net.w_horse.excelpojo.xml.ExcelPOJOXmlParser;
import net.w_horse.excelpojo.xml.tag.RetrieveFrom;
import net.w_horse.excelpojo.xml.tag.Use;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.w3c.dom.Element;

public class LabeledCellSeeker
extends AbstractCellSeeker {
    private String label;
    private String retrieveFrom;
    private String margedLabel;
    private boolean margedRows = false;

    @Override
    public void set(Element element, ExcelPOJOXmlParser excelPOJOXmlParser) {
        excelPOJOXmlParser.setCellSeeker(element, this);
    }

    @Override
    public void set(Annotation annotation, ExcelPOJOAnnotationParser excelPOJOAnnotationParser) {
        excelPOJOAnnotationParser.setCellSeeker(annotation, this);
    }

    @Override
    public boolean verify() throws IllegalArgumentException {
        if (this.getLabel() == null || this.getLabel().isEmpty()) {
            throw new IllegalArgumentException("The label is not specified.");
        }
        return true;
    }

    @Override
    public Object seekCellValue(HSSFSheet hSSFSheet, Class<?> clazz) throws CellNotFoundException {
        return this.getCellValue(hSSFSheet, this.seekCellPosition(hSSFSheet), clazz);
    }

    @Override
    protected AbstractCellSeeker.Offset seekCellPosition(HSSFSheet hSSFSheet) throws CellNotFoundException {
        return this.seekCellPosition(hSSFSheet, new AbstractCellSeeker.Offset(), new AbstractCellSeeker.Offset());
    }

    @Override
    protected AbstractCellSeeker.Offset seekCellPosition(HSSFSheet hSSFSheet, AbstractCellSeeker.Offset offset, AbstractCellSeeker.Offset offset2) throws CellNotFoundException {
        int n;
        AbstractCellSeeker.Offset offset3 = this.parseOffset(offset2);
        int n2 = n = hSSFSheet.getFirstRowNum() > offset.rowIndex ? hSSFSheet.getFirstRowNum() : offset.rowIndex;
        while (n <= hSSFSheet.getLastRowNum()) {
            HSSFRow hSSFRow = hSSFSheet.getRow(n);
            if (hSSFRow != null) {
                int n3;
                int n4 = n3 = hSSFRow.getFirstCellNum() > offset.colIndex ? hSSFRow.getFirstCellNum() : offset.colIndex;
                while (n3 <= hSSFRow.getLastCellNum()) {
                    HSSFCell hSSFCell = hSSFRow.getCell(n3 - 1);
                    if (hSSFCell != null && this.getCellValue(hSSFCell, String.class).equals(this.getLabel())) {
                        return new AbstractCellSeeker.Offset(hSSFCell.getRowIndex() + offset3.rowIndex, hSSFCell.getColumnIndex() + offset3.colIndex);
                    }
                    ++n3;
                }
            }
            ++n;
        }
        if (Use.equalsIgnoreCase(Use.REQUIRED, this.getUse())) {
            throw new CellNotFoundException("label='" + this.getLabel() + "'");
        }
        return null;
    }

    @Override
    public void setValue(HSSFSheet hSSFSheet, Object object) throws CellNotFoundException {
        this.setCellValue(this.getCell(hSSFSheet, this.seekCellPosition(hSSFSheet)), object);
    }

    @Override
    protected void setValue(HSSFSheet hSSFSheet, AbstractCellSeeker.Offset offset, AbstractCellSeeker.Offset offset2, Object object) throws CellNotFoundException {
        this.setCellValue(this.getCell(hSSFSheet, this.seekCellPosition(hSSFSheet, offset, offset2)), object);
    }

    private AbstractCellSeeker.Offset parseOffset(AbstractCellSeeker.Offset offset) {
        String string = this.getRetrieveFrom();
        int n = 0;
        if (this.getMargedLabel() != null && !this.getMargedLabel().isEmpty()) {
            n = Integer.parseInt(this.getMargedLabel());
        }
        AbstractCellSeeker.Offset offset2 = RetrieveFrom.equalsIgnoreCase(RetrieveFrom.LEFT, string) ? new AbstractCellSeeker.Offset(n, -1) : (RetrieveFrom.equalsIgnoreCase(RetrieveFrom.RIGHT, string) ? new AbstractCellSeeker.Offset(n, 1) : new AbstractCellSeeker.Offset(1, n));
        offset2.rowIndex += offset.rowIndex;
        offset2.colIndex += offset.colIndex;
        return offset2;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getLabel() {
        return this.label;
    }

    public void setRetrieveFrom(String string) {
        this.retrieveFrom = string;
    }

    public String getRetrieveFrom() {
        return this.retrieveFrom;
    }

    public void setMargedLabel(String string) {
        this.margedLabel = string;
    }

    public String getMargedLabel() {
        return this.margedLabel;
    }

    public boolean isMargedRows() {
        return this.margedRows;
    }

    public void setMargedRows(boolean bl) {
        this.margedRows = bl;
    }
}

