/*
 * Decompiled with CFR 0.152.
 */
package net.w_horse.excelpojo.excel.cellseeker;

import java.util.regex.Pattern;
import net.w_horse.excelpojo.ExcelPOJOBridge;
import net.w_horse.excelpojo.ExcelPOJOException;
import net.w_horse.excelpojo.converter.CellFieldConverter;
import net.w_horse.excelpojo.converter.NothingConverter;
import net.w_horse.excelpojo.excel.CellNotFoundException;
import net.w_horse.excelpojo.excel.ExcelUtils;
import net.w_horse.excelpojo.excel.cellseeker.CellSeeker;
import net.w_horse.excelpojo.xml.tag.Use;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.springframework.util.StringUtils;

public abstract class AbstractCellSeeker
implements CellSeeker {
    private ExcelPOJOBridge excelPOJOBridge;
    private String use = Use.NONE.getValue();
    private String range;
    private CellFieldConverter converter = new NothingConverter();

    protected abstract Offset seekCellPosition(Sheet var1) throws CellNotFoundException, IllegalArgumentException, ExcelPOJOException;

    protected abstract Offset seekCellPosition(Sheet var1, Offset var2, Offset var3) throws CellNotFoundException, IllegalArgumentException, ExcelPOJOException;

    @Override
    public boolean verify() throws IllegalArgumentException, ExcelPOJOException {
        Pattern pattern = Pattern.compile("\\(\\s*-?[0-9]+\\s*,\\s*-?[0-9]+\\s*\\)-\\(\\s*-?[0-9]+\\s*,\\s*-?[0-9]+\\s*\\)");
        if (StringUtils.hasLength((String)this.getRange()) && !pattern.matcher(this.getRange()).matches()) {
            throw new IllegalArgumentException("There is a mistake in the format of the range specification. \nFormat:(startRowIndex, startColIndex)-(endRowIndex, endColIndex)  rowIndex={1,2,3,...}, colIndex={1,2,3,...}");
        }
        return true;
    }

    protected <T> T getCellValue(Sheet sheet, Offset offset, Class<T> clazz) throws ExcelPOJOException {
        return this.getCellValue(sheet, offset, new Offset(), clazz);
    }

    protected <T> T getCellValue(Sheet sheet, Offset offset, Offset offset2, Class<T> clazz) throws ExcelPOJOException {
        return this.getCellValue(this.getCell(sheet, offset, offset2), clazz);
    }

    protected <T> T getCellValue(Cell cell, Class<T> clazz) throws ExcelPOJOException {
        return ExcelUtils.getCellValue(cell, clazz, this.getConverter());
    }

    protected Cell createCell(Sheet sheet, Offset offset, Offset offset2) {
        Cell cell;
        Row row = sheet.getRow(offset.rowIndex + offset2.rowIndex);
        if (row == null) {
            row = sheet.createRow(offset.rowIndex + offset2.rowIndex);
        }
        if ((cell = row.getCell(offset.colIndex + offset2.colIndex)) == null) {
            cell = row.createCell(offset.colIndex + offset2.colIndex);
        }
        return cell;
    }

    protected Cell getCell(Sheet sheet, Offset offset) {
        return this.getCell(sheet, offset, new Offset());
    }

    protected Cell getCell(Sheet sheet, Offset offset, Offset offset2) {
        if (offset == null) {
            return null;
        }
        return this.createCell(sheet, offset, offset2);
    }

    protected void setCellValue(Cell cell, Object object, CellFieldConverter cellFieldConverter) {
        ExcelUtils.setCellValue(cell, object, cellFieldConverter);
    }

    @Override
    public void setExcelPOJOBridge(ExcelPOJOBridge excelPOJOBridge) {
        this.excelPOJOBridge = excelPOJOBridge;
    }

    @Override
    public ExcelPOJOBridge getExcelPOJOBridge() {
        return this.excelPOJOBridge;
    }

    @Override
    public void setUse(String string) {
        this.use = string;
    }

    @Override
    public String getUse() {
        return this.use;
    }

    @Override
    public void setRange(String string) {
        this.range = string;
    }

    @Override
    public String getRange() {
        return this.range;
    }

    @Override
    public void setConverter(CellFieldConverter cellFieldConverter) {
        this.converter = cellFieldConverter;
    }

    @Override
    public CellFieldConverter getConverter() {
        return this.converter;
    }

    protected Offset getRangeStartCell() {
        return this.convRangeString2Offset(true);
    }

    protected Offset getRangeEndCell() {
        return this.convRangeString2Offset(false);
    }

    private Offset convRangeString2Offset(boolean bl) {
        String[] stringArray = this.getRange().split("\\)-\\(");
        String string = bl ? stringArray[0] : stringArray[1];
        String[] stringArray2 = bl ? string.substring(1).split(",") : string.substring(0, string.length() - 1).split(",");
        int n = Integer.valueOf(stringArray2[0].trim()) - 1;
        int n2 = Integer.valueOf(stringArray2[1].trim()) - 1;
        return new Offset(n, n2);
    }

    protected String convertOffset2RangeString(Offset offset, Offset offset2) {
        int n = offset.rowIndex;
        int n2 = offset.colIndex;
        int n3 = offset2.rowIndex < 0 ? -1 : n + offset2.rowIndex;
        int n4 = offset2.colIndex < 0 ? -1 : n2 + offset2.colIndex;
        String string = String.format("(%d,%d)", n + 1, n2 + 1);
        String string2 = String.format("(%d,%d)", n3 + 1, n4 + 1);
        return string + "-" + string2;
    }

    protected int getStartRowIndex(int n, int n2) {
        int n3;
        int n4 = n3 = n > n2 ? n : n2;
        if (StringUtils.hasLength((String)this.getRange()) && this.getRangeStartCell().rowIndex > 0) {
            n3 = n3 > this.getRangeStartCell().rowIndex ? n3 : this.getRangeStartCell().rowIndex;
        }
        return n3;
    }

    protected int getLimitRowIndex(int n) {
        int n2 = n;
        if (StringUtils.hasLength((String)this.getRange()) && this.getRangeEndCell().rowIndex > 0) {
            n2 = n2 < this.getRangeEndCell().rowIndex ? n2 : this.getRangeEndCell().rowIndex;
        }
        return n2;
    }

    protected int getStartColIndex(int n, int n2) {
        int n3;
        int n4 = n3 = n > n2 ? n : n2;
        if (StringUtils.hasLength((String)this.getRange()) && this.getRangeStartCell().colIndex > 0) {
            n3 = n3 > this.getRangeStartCell().colIndex ? n3 : this.getRangeStartCell().colIndex;
        }
        return n3;
    }

    protected int getLimitColumnIndex(int n) {
        int n2 = n;
        if (StringUtils.hasLength((String)this.getRange()) && this.getRangeEndCell().colIndex > 0) {
            n2 = n2 < this.getRangeEndCell().colIndex ? n2 : this.getRangeEndCell().colIndex;
        }
        return n2;
    }

    protected class Offset {
        public int rowIndex = 0;
        public int colIndex = 0;

        public Offset() {
        }

        public Offset(Offset offset) {
            this.rowIndex = offset.rowIndex;
            this.colIndex = offset.colIndex;
        }

        public Offset(int n, int n2) {
            this.rowIndex = n;
            this.colIndex = n2;
        }

        public Offset add(Offset offset) {
            this.rowIndex += offset.rowIndex;
            this.colIndex += offset.colIndex;
            return this;
        }

        public Offset negate() {
            return new Offset(-this.rowIndex, -this.colIndex);
        }
    }
}

