/*
 * Decompiled with CFR 0.152.
 */
package net.w_horse.excelpojo;

import java.beans.PropertyDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import net.w_horse.excelpojo.ExcelPOJOException;
import net.w_horse.excelpojo.annotation.Bean;
import net.w_horse.excelpojo.annotation.ExcelPOJOAnnotationParser;
import net.w_horse.excelpojo.bean.Utils;
import net.w_horse.excelpojo.excel.SheetNotFoundException;
import net.w_horse.excelpojo.excel.cellseeker.AbstractCellSeeker;
import net.w_horse.excelpojo.excel.cellseeker.AbstractRepeatsSeeker;
import net.w_horse.excelpojo.excel.cellseeker.CellSeeker;
import net.w_horse.excelpojo.excel.cellseeker.ConstantValueCellSeeker;
import net.w_horse.excelpojo.excel.cellseeker.HorizontalRepeatsSeeker;
import net.w_horse.excelpojo.excel.cellseeker.LabeledCellSeeker;
import net.w_horse.excelpojo.excel.cellseeker.MappedCellSeeker;
import net.w_horse.excelpojo.excel.cellseeker.PointedCellSeeker;
import net.w_horse.excelpojo.excel.cellseeker.VerticalRepeatsSeeker;
import net.w_horse.excelpojo.xml.tag.RetrieveType;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.ResourceUtils;

public class ExcelPOJOBridge {
    private String sheetName;
    private String targetClass = "";
    private HashMap<String, CellSeeker> targetClassProperties = new HashMap();
    private String retrieveType;
    private CellSeeker cellSeeker;

    public ExcelPOJOBridge() {
    }

    public ExcelPOJOBridge(Class<?> clazz) throws ExcelPOJOException {
        Bean bean = clazz.getAnnotation(Bean.class);
        if (bean == null) {
            throw new ExcelPOJOException("There is no annotation specified on the target class.");
        }
        switch (bean.retrieveType()) {
            case CONSTANT_VALUE: 
            case LABELED_CELL: 
            case POINTED_CELL: {
                throw new ExcelPOJOException(String.format("There is an invalid retrieveType(%s) in Bean.", bean.retrieveType().getValue()));
            }
        }
        try {
            this.setSheetName(bean.sheetName());
            ExcelPOJOAnnotationParser excelPOJOAnnotationParser = new ExcelPOJOAnnotationParser();
            excelPOJOAnnotationParser.setTargetClassProperties(this.getTargetClassProperties(), clazz);
            if (bean.retrieveType() == RetrieveType.NONE) {
                this.setTargetClass(clazz.getCanonicalName());
            } else {
                CellSeeker cellSeeker = this.buildCellSeeker(bean.retrieveType());
                excelPOJOAnnotationParser.setTargetClass(clazz.getCanonicalName());
                cellSeeker.set(bean, excelPOJOAnnotationParser);
                this.setCellSeeker(cellSeeker);
            }
        }
        catch (Throwable throwable) {
            throw new ExcelPOJOException(throwable);
        }
    }

    public Object load(String string) throws ExcelPOJOException {
        if (this.getSheetName() == null || this.getSheetName().isEmpty()) {
            throw new ExcelPOJOException("There is no sheet name specified.");
        }
        return this.load(string, this.getSheetName());
    }

    public Object load(String string, String string2) throws ExcelPOJOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(ResourceUtils.getFile((String)string));
            Object object = this.load(fileInputStream, string2);
            return object;
        }
        catch (ExcelPOJOException excelPOJOException) {
            throw excelPOJOException;
        }
        catch (Throwable throwable) {
            throw new ExcelPOJOException(throwable);
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public Object load(InputStream inputStream) throws ExcelPOJOException {
        return this.load(inputStream, this.getSheetName());
    }

    public Object load(InputStream inputStream, String string) throws ExcelPOJOException {
        Object object;
        try {
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            Sheet sheet = workbook.getSheet(string);
            if (sheet == null) {
                throw new SheetNotFoundException(string);
            }
            if (this.getCellSeeker() != null) {
                if (RetrieveType.LABELED_CELL.equals(this.getRetrieveType()) || RetrieveType.POINTED_CELL.equals(this.getRetrieveType()) || RetrieveType.CONSTANT_VALUE.equals(this.getRetrieveType())) {
                    throw new ExcelPOJOException(String.format("There is an invalid retrieveType(%s) in Bean.", this.getRetrieveType()));
                }
                this.getCellSeeker().verify();
                return this.getCellSeeker().seekCellValue(sheet, null);
            }
            Class clazz = ClassUtils.forName((String)this.getTargetClass());
            ExcelPOJOAnnotationParser excelPOJOAnnotationParser = new ExcelPOJOAnnotationParser();
            excelPOJOAnnotationParser.setTargetClassProperties(this.getTargetClassProperties(), clazz);
            object = Utils.instantiateTarget(this.getTargetClass());
            for (String string2 : this.getTargetClassProperties().keySet()) {
                PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptor((Class)clazz, (String)string2);
                CellSeeker cellSeeker = this.getTargetClassProperties().get(string2);
                cellSeeker.verify();
                Object object2 = cellSeeker.seekCellValue(sheet, propertyDescriptor.getPropertyType());
                ReflectionUtils.invokeMethod((Method)propertyDescriptor.getWriteMethod(), (Object)object, (Object[])new Object[]{object2});
            }
            for (String string2 : this.getTargetClassProperties().keySet()) {
                this.setSucceedsValue(object, string2);
            }
        }
        catch (ExcelPOJOException excelPOJOException) {
            throw excelPOJOException;
        }
        catch (Throwable throwable) {
            throw new ExcelPOJOException(throwable);
        }
        return object;
    }

    public void save(String string, Object object) throws ExcelPOJOException {
        this.save(string, this.getSheetName(), string, object);
    }

    public void save(String string, String string2, Object object) throws ExcelPOJOException {
        this.save(string, string2, string, object);
    }

    public void save(String string, String string2, String string3, Object object) throws ExcelPOJOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(ResourceUtils.getFile((String)string));
            Workbook workbook = WorkbookFactory.create((InputStream)fileInputStream);
            this.save(workbook, string2, string3, object);
        }
        catch (ExcelPOJOException excelPOJOException) {
            throw excelPOJOException;
        }
        catch (Throwable throwable) {
            throw new ExcelPOJOException(throwable);
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public void save(Workbook workbook, String string, String string2, Object object) throws ExcelPOJOException {
        FileOutputStream fileOutputStream = null;
        try {
            Sheet sheet = workbook.getSheet(string);
            if (sheet == null) {
                throw new SheetNotFoundException(string);
            }
            if (this.getCellSeeker() != null) {
                this.getCellSeeker().setValue(sheet, object);
            }
            for (String string3 : this.getTargetClassProperties().keySet()) {
                PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptor(object.getClass(), (String)string3);
                if (propertyDescriptor == null) continue;
                CellSeeker cellSeeker = this.getTargetClassProperties().get(string3);
                Object object2 = ReflectionUtils.invokeMethod((Method)propertyDescriptor.getReadMethod(), (Object)object, (Object[])new Object[0]);
                cellSeeker.setValue(sheet, object2);
            }
            fileOutputStream = new FileOutputStream(ResourceUtils.getFile((String)string2));
            workbook.write((OutputStream)fileOutputStream);
        }
        catch (ExcelPOJOException excelPOJOException) {
            throw excelPOJOException;
        }
        catch (Throwable throwable) {
            throw new ExcelPOJOException(throwable);
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public void setSheetName(String string) {
        this.sheetName = string;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setTargetClass(String string) {
        this.targetClass = string;
    }

    public String getTargetClass() {
        return this.targetClass;
    }

    public void setTargetClassProperties(HashMap<String, CellSeeker> hashMap) {
        this.targetClassProperties = hashMap;
    }

    public HashMap<String, CellSeeker> getTargetClassProperties() {
        return this.targetClassProperties;
    }

    public void setCellSeeker(CellSeeker cellSeeker) {
        this.cellSeeker = cellSeeker;
    }

    public String getRetrieveType() {
        return this.retrieveType;
    }

    public void setRetrieveType(String string) {
        this.retrieveType = string;
    }

    public CellSeeker getCellSeeker() {
        return this.cellSeeker;
    }

    private CellSeeker buildCellSeeker(RetrieveType retrieveType) {
        AbstractCellSeeker abstractCellSeeker = null;
        switch (retrieveType) {
            case LABELED_CELL: {
                abstractCellSeeker = new LabeledCellSeeker();
                break;
            }
            case POINTED_CELL: {
                abstractCellSeeker = new PointedCellSeeker();
                break;
            }
            case CONSTANT_VALUE: {
                abstractCellSeeker = new ConstantValueCellSeeker();
                break;
            }
            case VERTICAL_REPEATS: {
                abstractCellSeeker = new VerticalRepeatsSeeker();
                break;
            }
            case HORIZONTAL_REPEATS: {
                abstractCellSeeker = new HorizontalRepeatsSeeker();
                break;
            }
            case MAPPED_CELL: {
                abstractCellSeeker = new MappedCellSeeker();
            }
        }
        return abstractCellSeeker;
    }

    private void setSucceedsValue(Object object, String string) {
        CellSeeker cellSeeker = this.getTargetClassProperties().get(string);
        if (!(cellSeeker instanceof AbstractRepeatsSeeker)) {
            return;
        }
        AbstractRepeatsSeeker abstractRepeatsSeeker = (AbstractRepeatsSeeker)cellSeeker;
        if (abstractRepeatsSeeker.getSucceedFields().isEmpty()) {
            return;
        }
        PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptor(object.getClass(), (String)string);
        Object object2 = ReflectionUtils.invokeMethod((Method)propertyDescriptor.getReadMethod(), (Object)object);
        String string2 = abstractRepeatsSeeker.getSucceedFields();
        string2 = string2.substring(1, string2.length() - 1);
        for (String string3 : string2.split(",")) {
            String[] stringArray = string3.split("=");
            String string4 = stringArray[0].trim();
            String string5 = stringArray[1].trim();
            PropertyDescriptor propertyDescriptor2 = BeanUtils.getPropertyDescriptor(object.getClass(), (String)string5);
            Object object3 = ReflectionUtils.invokeMethod((Method)propertyDescriptor2.getReadMethod(), (Object)object);
            if (ClassUtils.isAssignable(List.class, object2.getClass())) {
                for (Object e : (List)object2) {
                    propertyDescriptor2 = BeanUtils.getPropertyDescriptor(e.getClass(), (String)string4);
                    ReflectionUtils.invokeMethod((Method)propertyDescriptor2.getWriteMethod(), e, (Object[])new Object[]{object3});
                }
                continue;
            }
            if (object2.getClass().isArray()) {
                for (Object object4 : (Object[])object2) {
                    propertyDescriptor2 = BeanUtils.getPropertyDescriptor(object4.getClass(), (String)string4);
                    ReflectionUtils.invokeMethod((Method)propertyDescriptor2.getWriteMethod(), (Object)object4, (Object[])new Object[]{object3});
                }
                continue;
            }
            throw new IllegalArgumentException(String.format("An illegal type(%s) is specified for verticalRepeats / horizontalRepeats. ", object2.getClass().getCanonicalName()));
        }
    }
}

