
require 'test/unit/testcase'

class ExerbTestCase < Test::Unit::TestCase

  def make(basename, kcode = 'none', internal_name = basename)
    internal_name = basename + '.rb' if internal_name == basename

    File.open(basename + '.rbc', 'w') { |file|
      file.puts "kcode	#{kcode}"
      file.puts "script	#{internal_name}	#{basename}.rb"
    }

    File.open(basename + '.mak', 'w') { |file|
      file.puts "all: #{basename}.exe"
      file.puts "#{basename}.exe: #{basename}.rbc"
      file.puts "	ruby ../bin/exerb.rb -C ../project/ruby167c/release/ruby167c.exe #{basename}.rbc"
    }

    `make -f #{basename}.mak`
  end
  private :make

  def normalize(string)
    return string.gsub(/\r\n/, "\n")
  end
  private :normalize

end
