
require 'test/unit/testcase'

class ExerbTestCase < Test::Unit::TestCase

  def make(basename, kcode = 'none', internal_name = basename, files = [])
    internal_name = basename + '.rb' if internal_name == basename
    make_rbc(basename, internal_name, kcode, files)
    make_mak(basename, files)
    make_exe(basename)
  end
  private :make

  def make_rbc(basename, internal_name, kcode, files = [])
    File.open(basename + '.rbc', 'w') { |file|
      file.puts "kcode	#{kcode}"
      file.puts "script	#{internal_name}	#{basename}.rb"

      files.each { |name|
        file.puts "script	#{name}	#{name}"
      }
    }
  end
  private :make_rbc

  def make_mak(basename, files)
    corefile = '../project/ruby167c/release/ruby167c.exe'

    File.open(basename + '.mak', 'w') { |file|
      file.puts "all: #{basename}.exe"
      file.puts
      file.puts "#{basename}.exe: #{basename}.rb #{files.join(' ')} #{basename}.rbc #{corefile}"
      file.puts "	ruby ../bin/exerb.rb -C #{corefile} #{basename}.rbc"
      file.puts "	chmod u+x #{basename}.exe"
      file.puts
      file.puts "go: #{basename}.exe"
      file.puts "	#{basename}.exe"
      file.puts
      file.puts "clean: "
      file.puts "	rm #{basename}.exe"
    }
  end
  private :make_mak

  def make_exe(basename)
    `make -f #{basename}.mak`
  end
  private :make_exe

  def normalize(string)
    return string.gsub(/\r\n/, "\n")
  end
  private :normalize

  def execute(cmd)
    return "\n" + normalize(`#{cmd}`)
  end
  private :execute

end
