
#==============================================================================#
# $Id: config.rb,v 1.18 2005/04/28 04:10:09 yuya Exp $
#==============================================================================#

require 'rbconfig'

#==============================================================================#

module Exerb

  # Search directories of a core.
  CORE_PATH = [
    File.join(Config::CONFIG['datadir'], 'exerb'),
    '.',
  ]

  # Name definitions of a core.
  CORE_NAME = {
    'cui'   => 'ruby182c.exc',
    'cuid'  => 'ruby182cd.exc',
    'cuirt' => 'ruby182crt.exc',
    'gui'   => 'ruby182g.exc',
    'guid'  => 'ruby182gd.exc',
    'guirt' => 'ruby182grt.exc',
    'cui19' => 'ruby190c.exc',
    'gui19' => 'ruby190g.exc',
  }

  # Descriptions of a core.
  CORE_DESC = {
    # FIXME: Add descriptions
    # 'ruby182c.exc' => '...',
  }

  # If running exerb on exerb, Add self path to search directories of a core.
  if $Exerb
    CORE_PATH.unshift(File.dirname(ExerbRuntime.filepath))
  end

end # Exerb

#==============================================================================#

# Load a configuration file of Exerb Core Collection if found that.
configcc = File.join(File.dirname(__FILE__), 'configcc.rb')
if File.exist?(configcc)
  require(configcc)
end

#==============================================================================#
#==============================================================================#
