/**********************************************************************

  env.h -

  $Author: matz $
  $Date: 2005/03/04 06:47:44 $
  created at: Mon Jul 11 11:53:03 JST 1994

  Copyright (C) 1993-2003 Yukihiro Matsumoto

**********************************************************************/

#ifndef ENV_H
#define ENV_H

RUBY_EXTERN struct FRAME {
    VALUE self;
    int argc;
    ID callee;
    ID this_func;
    VALUE this_class;
    struct FRAME *prev;
    struct FRAME *tmp;
    struct RNode *node;
    int iter;
    int flags;
    unsigned long uniq;
} *ruby_frame;

void rb_gc_mark_frame _((struct FRAME *));

#define FRAME_DMETH  1

RUBY_EXTERN struct SCOPE {
    struct RBasic super;
    ID *local_tbl;
    VALUE *local_vars;
    int flags;
} *ruby_scope;

#define SCOPE_ALLOCA  0
#define SCOPE_MALLOC  1
#define SCOPE_NOSTACK 2
#define SCOPE_DONT_RECYCLE 4

RUBY_EXTERN int ruby_in_eval;

RUBY_EXTERN VALUE ruby_class;

struct RVarmap {
    struct RBasic super;
    ID id;
    VALUE val;
    struct RVarmap *next;
};
RUBY_EXTERN struct RVarmap *ruby_dyna_vars;

#endif /* ENV_H */
