
#==============================================================================#
# exerb/entryheader.rb
# $Id: entryheader.rb,v 1.2 2003/01/14 10:20:37 yuya Exp $
#==============================================================================#

#==============================================================================#
# Exerb Module
module Exerb

  #============================================================================#
  # EntryHeader Class
  class EntryHeader

    #==========================================================================#
    # Initialize Method

    def initialize
      @name_id = nil
      @type    = nil
      @offset  = nil
      @size    = nil
    end

    #==========================================================================#
    # Accessor

    attr_accessor :name_id, :type, :offset, :size

    #==========================================================================#
    # Class Methods

    def self.size
      return 4 * 4
    end

    #==========================================================================#
    # Instance Methods

    def pack
      return [@name_id, @type, @offset, @size].pack('L4')
    end

  end # EntryHeader

end # Exerb

#==============================================================================#
#==============================================================================#
