
#==============================================================================#
# exerb/entrytable.rb
# $Id: entrytable.rb,v 1.3 2003/02/21 05:14:48 yuya Exp $
#==============================================================================#

#==============================================================================#
# Exerb Module
module Exerb

  #============================================================================#
  # EntryTable Class
  class EntryTable

    def initialize
      @entries = []
    end

    def add(name_id, type, data)
      @entries << Entry.new(name_id, type, data)
    end

    def size
      return @entries.size
    end

    def pack
      header_size = EntryHeader.size * @entries.size
      header = ''
      table  = ''

      @entries.each { |entry|
        entry_header = EntryHeader.new
        entry_header.name_id = entry.name_id
        entry_header.type    = entry.type
        entry_header.offset  = header_size + table.size
        entry_header.size    = entry.size

        header << entry_header.pack
        table  << entry.pack
      }

      return header + table
    end

    #==========================================================================#
    # Entry Class
    class Entry

      def initialize(name_id, type, data)
        @name_id = name_id
        @type    = type
        @data    = data
      end

      attr_reader :name_id, :type, :data

      def size
        return @data.size
      end

      def pack
        return @data + "\0"
      end

    end # Entry

  end # EntryTable

end # Exerb

#==============================================================================#
#==============================================================================#
