// $Id: exerbmod.cpp,v 1.4 2003/02/20 09:18:47 yuya Exp $

////////////////////////////////////////////////////////////////////////////////

#include "exerb.h"

////////////////////////////////////////////////////////////////////////////////

static VALUE rb_exerb_s_runtime_p(VALUE self);
static VALUE rb_exerb_s_filepath(VALUE self);
static VALUE rb_exerb_s_filename(VALUE self);
static VALUE rb_exerb_s_loadicon(VALUE self, VALUE id);
static VALUE rb_exerb_s_loadcursor(VALUE self, VALUE id);

static LPCTSTR value2id(VALUE value);

////////////////////////////////////////////////////////////////////////////////

void Init_Exerb()
{
	VALUE mExerb = ::rb_define_module("Exerb");
	::rb_define_singleton_method(mExerb, "runtime?", (RUBYPROC)rb_exerb_s_runtime_p, 0);
	::rb_define_singleton_method(mExerb, "filepath", (RUBYPROC)rb_exerb_s_filepath, 0);
	::rb_define_singleton_method(mExerb, "filename", (RUBYPROC)rb_exerb_s_filename, 0);
	::rb_define_singleton_method(mExerb, "loadicon", (RUBYPROC)rb_exerb_s_loadicon, 1);
	::rb_define_singleton_method(mExerb, "loadcursor", (RUBYPROC)rb_exerb_s_loadcursor, 1);
}

////////////////////////////////////////////////////////////////////////////////

static VALUE
rb_exerb_s_runtime_p(VALUE self)
{
	return Qtrue;
}

static VALUE
rb_exerb_s_filepath(VALUE self)
{
	char filepath[MAX_PATH] = "";
	::ExGetSelfFilePath(filepath, sizeof(filepath));
	return ::rb_str_new2(filepath);
}

static VALUE
rb_exerb_s_filename(VALUE self)
{
	char filename[MAX_PATH] = "";
	::ExGetSelfFileName(filename, sizeof(filename));
	return ::rb_str_new2(filename);
}

static VALUE
rb_exerb_s_loadicon(VALUE self, VALUE id)
{
	HICON handle = ::LoadIcon(::GetModuleHandle(NULL), ::value2id(id));
	if ( !handle ) ::ExRaiseExceptionVar(rb_eRuntimeError, IDS_FAIL_LOAD_ICON, ::GetLastError());

	return INT2NUM((int)handle);
}

static VALUE
rb_exerb_s_loadcursor(VALUE self, VALUE id)
{
	HCURSOR handle = ::LoadCursor(::GetModuleHandle(NULL), ::value2id(id));
	if ( !handle ) ::ExRaiseExceptionVar(rb_eRuntimeError, IDS_FAIL_LOAD_CURSOR, ::GetLastError());

	return INT2NUM((int)handle);
}

static LPCTSTR
value2id(VALUE value)
{
	switch ( TYPE(value) ) {
	case T_FIXNUM:
		return MAKEINTRESOURCE(FIX2INT(value));
	case T_STRING:
		return RSTRING(value)->ptr;
	default:
		::rb_raise(rb_eArgError, "argument needs to be integer or string");
		return NULL;
	}
}

////////////////////////////////////////////////////////////////////////////////
