
#==============================================================================#
# $Id: resource_directory_root.rb,v 1.2 2003/11/18 18:48:30 yuya Exp $
#==============================================================================#

require 'exerb/utility'
require 'exerb/win32/resource_directory'

#==============================================================================#

module Exerb

  module Win32

    class ResourceDirectoryRoot < ResourceDirectory

      def initialize(delta)
        super(0)
        @delta = delta
      end

      attr_accessor :delta

      def serial
        return self.serialize([[], [], []], 0)
      end

      def pack_all
        table   = Hash.new(0)
        address = 0
        buffer  = ''

        self.serial.each { |entries|
          entries.flatten!
          entries.compact!
        }.each { |entries|
          entries.each { |entry|
            table[entry] = address
            address += entry.pack(table, @delta).size
          }
          address += (address % 16 == 0 ? 0 : 16 - address % 16)
        }.each { |entries|
          entries.each { |entry|
            buffer << entry.pack(table, @delta)
          }
          buffer = Utility.alignment16(buffer)
        }

        return buffer
      end

    end # ResourceDirectoryRoot

  end # Win32

end # Exerb

#==============================================================================#
#==============================================================================#
