
#==============================================================================#
# $Id: utility.rb,v 1.9 2003/11/21 16:25:51 yuya Exp $
#==============================================================================#

module Exerb

  module Utility

    def self.alignment(bin, align)
      if bin.size % align == 0
        return bin
      else
        return bin + "\0" * (align - (bin.size % align))
      end
    end

    def self.alignment16(bin)
      return alignment(bin, 16)
    end

    def self.alignment4k(bin)
      return alignment(bin, 1024 * 4)
    end

    def self.find_file_by_filename(filename, path)
      return filename if File.expand_path(filename) == filename && File.exist?(filename)
      return path.collect { |dir| File.join(dir, filename) }.find { |filepath| File.exist?(filepath) }
    end

    def self.find_file_by_name(name, table, path)
      return nil unless table.has_key?(name)
      return self.find_file_by_filename(table[name], path)
    end

    def self.find_core_by_filename(filename)
      return self.find_file_by_filename(filename, CORE_PATH)
    end

    def self.find_core_by_name(name, error = false)
      path = self.find_file_by_name(name, CORE_NAME, CORE_PATH)
      raise(ExerbError, "unknown core name --- #{name}") if path.nil? && error
      return path
    end

    def self.find_plugin_by_filename(filename)
      return self.find_file_by_filename(filename, PLUGIN_PATH)
    end

    def self.find_plugin_by_name(name)
      return self.find_file_by_name(name, PLUGIN_NAME, PLUGIN_PATH)
    end

    def self.sjis2unicode(value)
      require 'uconv'
      return Uconv.sjistou16(value)
    end

    def self.unicode2sjis(value)
      require 'uconv'
      return Uconv.u16tosjis(value)
    end

  end # Utility

end # Exerb

#==============================================================================#
#==============================================================================#
