
#==============================================================================#
# $Id: resource_entry_data.rb,v 1.4 2003/11/28 04:43:51 yuya Exp $
#==============================================================================#

require 'exerb/utility'

#==============================================================================#

module Exerb

  module Win32

    class ResourceEntryData

      def initialize(data)
        @data = data
      end

      attr_accessor :data

      def self.read(io, base, size)
        return self.new(nil).read(io, base, size)
      end

      def serialize(elements, level)
        elements[2][level] = [] if elements[2][level].nil?
        elements[2][level] << self
        return elements
      end

      def pack(table, reloc, base)
        return Utility.alignment16(@data)
      end

      def size
        return @data.size
      end

      def read(io, base, size)
        @data = io.read(size)
        return self
      end

    end # ResourceEntryData

  end # Win32

end # Exerb

#==============================================================================#
#==============================================================================#
