
#==============================================================================#
# $Id: testcase.rb,v 1.14 2003/11/29 09:33:27 yuya Exp $
#==============================================================================#

require 'test/unit/testcase'
require 'exerb/exerb'

#==============================================================================#

class ExerbTestCase < Test::Unit::TestCase

  def set_up
    @name = self.name
    self.setup_exe
  end

  def setup_exe
    create_exe(@name)
  end

  def name
    raise(NotImplementedError)
  end

  def create_exe(name, exename = name)
    corefile   = '../data/exerb/ruby181c.exc'
    recipe     = Exerb::Recipe.new_from_file("#{name}/#{exename}.exr")
    executable = Exerb::Executable.new_from_file(corefile)
    executable.rsrc.add_archive(recipe.archive)
    executable.write_to_file("#{name}/#{exename}.exe")
  end

  def execute_cmd(cmd)
    return `#{cmd}`.gsub(/\r\n/, "\n")
  end

  def execute_exe(name, argv = '')
    return execute_cmd("#{name}/#{name}.exe #{argv}")
  end

  def read_file(filepath)
    return File.open(filepath) { |file| file.read }
  end

  def read_result(name)
    return read_file("#{name}/#{name}.ret")
  end

end # ExerbTestCase

#==============================================================================#
#==============================================================================#
