
#==============================================================================#
# exerb/archiveheader.rb
#==============================================================================#

#==============================================================================#
# Exerb Module
module Exerb

  #============================================================================#
  # ArchiveHeader Class
  class ArchiveHeader

    OPTIONS_KCODE_NONE = 0
    OPTIONS_KCODE_EUC  = 1
    OPTIONS_KCODE_SJIS = 2
    OPTIONS_KCODE_UTF8 = 3

    #==========================================================================#
    # Initialize Method

    def initialize
      @signature        = nil
      @time_date_stamp  = nil
      @offset_to_name   = nil
      @number_of_name   = nil
      @offset_to_script = nil
      @number_of_script = nil
      @offset_to_dll    = nil
      @number_of_dll    = nil
      @options          = nil
    end

    #==========================================================================#
    # Accessor

    attr_accessor :signature, :time_date_stamp, :offset_to_name, :number_of_name,
                  :offset_to_script, :number_of_script, :offset_to_dll, :number_of_dll, :options

    #==========================================================================#
    # Class Methods

    def self.size
      return 4 * 9
    end

    #==========================================================================#
    # Instance Methods

    def pack
      return [@signature, @time_date_stamp, @offset_to_name, @number_of_name, @offset_to_script, @number_of_script, @offset_to_dll, @number_of_dll, @options].pack('Z4L8')
    end

  end # ArchiveHeader

end # Exerb

#==============================================================================#
# end of source
#==============================================================================#
