
#==============================================================================#
# exerb/mkrbc.rb
#==============================================================================#

END {
  output = $0.sub(/\.rb$/, '.rbc')
  output << ".rbc" unless /\.rbc$/ =~ output

  File.open(output, 'w') { |file|
    file.puts "# generated by mkrbc.rb"
    file.puts "kcode\t#{$KCODE.downcase}"
    file.puts "script\t#{$0}\t#{$0}"

    $".sort.each { |filename|
      next if /#{File.basename(__FILE__)}$/ =~ filename

      type = case filename
             when /\.rb$/i       then "script"
             when /\.(so|dll)$/i then "library"
             else "#unknown"
             end

      if File.exist?(filename)
        file.puts "#{type}\t#{filename}\t#{filename}"
      else
        $:.each { |path|
          filepath = File.join(path, filename)
          if File.exist?(filepath)
            file.puts "#{type}\t#{filename}\t#{filepath}"
            break
          end
        }
      end
    }
  }
}

#==============================================================================#
# end of source
#==============================================================================#
