
#==============================================================================#
# exerb/nametable.rb
#==============================================================================#

#==============================================================================#
# Exerb Module
module Exerb

  #============================================================================#
  # NameTable Class
  class NameTable

    #==========================================================================#
    # Initialize Method

    def initialize
      @name = []
    end

    #==========================================================================#
    # Instance Methods

    def add(name)
      @name << Item.new(@name.size + 1, name)
      return @name.size
    end

    def size
      return @name.size
    end

    def pack
      header = ''
      table  = ''
      header_size = @name.size * NameHeader.size

      @name.each { |name|
        name_header = NameHeader.new
        name_header.id     = name.id
        name_header.offset = header_size + table.size
        name_header.size   = name.size

        header << name_header.pack
        table  << name.pack
      }

      return header + table
    end

    #==========================================================================#
    # Item Class
    class Item

      #========================================================================#
      # Initialize Method

      def initialize(id, name)
        @id   = id
        @name = name
      end

      #========================================================================#
      # Accessor

      attr_reader :id, :name

      #========================================================================#
      # Instance Methods

      def size
        return @name.size
      end

      def pack
        return @name + "\0"
      end

    end # Item

  end # NameTable

end # Exerb

#==============================================================================#
# end of source
#==============================================================================#
