=begin

$Id: README.en.rd,v 1.41 2003/12/26 10:03:41 yuya Exp $

= Exerb

* ((<1. Overview>))
* ((<2. Features>))
* ((<3. Installation>))
* ((<4. Documentation>))
* ((<5. The core>))
* ((<6. How to get>))
* ((<7. Checking environment>))
* ((<8. License>))
* ((<9. Copyright>))
* ((<10. Exemption from responsibility>))
* ((<11. Acknowledgment>))
* ((<12. Author>))
* ((<13. And>))

== 1. Overview

Exerb is the software which converts scripts and extension-libraries of Ruby
into an executable file of Microsoft Windows which can execute alone and
independently.

== 2. Features

The main features of Exerb are as follows.

* Exerb can convert a number of files into an executable file in one piece.
* An executable file which is created by Exerb can execute on an environment
  where Ruby is not installed.
* Any compiler is not needed to create an executable file by Exerb.

== 3. Installation

Run following instruction set to install Exerb.
You may need an administrator's authority to run "install".

  $ ruby setup.rb config
  $ ruby setup.rb setup
  # ruby setup.rb install

== 4. Documentation

: ((<"ChangeLog.en.rd"|URL:ChangeLog.en.html>))
    ChangeLog.

: ((<"doc/tutorial.en.rd"|URL:doc/tutorial.en.html>))
    Tutorial.

: ((<"doc/example.en.rd"|URL:doc/example.en.html>))
    Examples.

: ((<"doc/command.en.rd"|URL:doc/command.en.html>))
    Command reference.

: ((<"doc/recipe.en.rd"|URL:doc/recipe.en.html>))
    About the recipe file.

== 5. The core

The package of Exerb contains following core files.

: ruby181c.exc
    This core is the CUI version which can execute alone.

: ruby181g.exc
    This core is the GUI version which can execute alone.

: ruby181crt.exc
    This core is the CUI version which used the runtime-library of Exerb.

: ruby181grt.exc
    This core is the GUI version which used the runtime-library of Exerb.

The difference between the CUI version and the GUI version is as follows.

: In the GUI version
    * Standard I/O can be used.
    * When an exception is raised, the message is outputted to a console.

: In the GUI version
    * Standard I/O can't be used.
    * When an exception is raised, the message is displayed to a dialog box.

== 6. How to get

You can get the latest information and version of Exerb at the following URL.

* ((<URL:http://exerb.sourceforge.jp/index.en.html>))
* ((<URL:http://sourceforge.jp/projects/exerb/>))

And you can get the information and source code of Ruby at the following URL.

* ((<URL:http://www.ruby-lang.org/>))

== 7. Checking environment

We checked out that the executable file created by Exerb can run on following
environments.

* Microsoft Windows Longhorn Build 4051
* Microsoft Windows Server 2003
* Microsoft Windows XP
* Microsoft Windows 2000
* Microsoft Windows Me
* Microsoft Windows 98 2nd Edition
* Microsoft Windows 98

== 8. License

You can redistribute it and/or modify it under the terms of the	LGPL.

== 9. Copyright

* The Ruby part of Exerb is copyrighted by Yukihiro Matsumoto.
* The others are copyrighted by Yuya Kato.

== 10. Exemption from responsibility

THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

== 11. Acknowledgment

We would like to thank Yukihiro Matsumoto and the other people who are
concerned in the development of the great language Ruby.
Thanks for the great language!

== 12. Author

Yuya Kato <yuya@katoden.co.jp>

I'll be happy if you send me your advices, impressions, demands or bug reports.

== 13. And

Good Ruby life. :-)

=end
