
#==============================================================================#
# $Id: archive.rb,v 1.32 2004/01/20 21:12:41 yuya Exp $
#==============================================================================#

require 'exerb/name_table'
require 'exerb/file_table'
require 'exerb/plugin_table'

#==============================================================================#

module Exerb

  class Archive

    def initialize(kcode = 'none')
      @name_table   = NameTable.new
      @file_table   = FileTable.new
      @plugin_table = PluginTable.new
      @kcode        = kcode
    end

    attr_reader   :name_table, :file_table, :plugin_table
    attr_accessor :kcode

    def add_ruby_script(name, data, flag = 0)
      @file_table.add_ruby_script(@name_table.add(name), data, flag)
    end

    def add_ruby_script_from_file(name, path, flag = 0)
      @file_table.add_ruby_script_from_file(@name_table.add(name), path, flag)
    end

    def add_bruby_binary(name, data, flag = 0)
      @file_table.add_bruby_binary(@name_table.add(name), data, flag)
    end

    def add_bruby_binary_from_file(name, path, flag = 0)
      @file_table.add_bruby_binary_from_file(@name_table.add(name), path, flag)
    end

    def add_extension_library(name, data, flag = 0)
      @file_table.add_extension_library(@name_table.add(name), data, flag)
    end

    def add_extension_library_from_file(name, path, flag = 0)
      @file_table.add_extension_library_from_file(@name_table.add(name), path, flag)
    end

    def add_dynamic_library(name, data, flag = 0)
      @file_table.add_dynamic_library(@name_table.add(name), data, flag)
    end

    def add_dynamic_library_from_file(path, flag = 0)
      @file_table.add_dynamic_library_from_file(@name_table.add(File.basename(path)), path, flag)
    end

    def add_resource_library(name, data, flag = 0)
      @file_table.add_resource_library(@name_table.add(name), data, flag)
    end

    def add_resource_library_from_file(path, flag = 0)
      @file_table.add_resource_library_from_file(@name_table.add(File.basename(path)), path, flag)
    end

    def add_data_binary(name, data, flag = 0)
      @file_table.add_data_binary(@name_table.add(name), data, flag)
    end

    def add_data_binary_from_file(name, path, flag = 0)
      @file_table.add_data_binary_from_file(@name_table.add(name), path, flag)
    end

    def add_plugin(data)
      @plugin_table.add(data)
    end

    def add_plugin_from_file(path)
      @plugin_table.add_from_file(path)
    end

    def pack
      case @kcode.downcase.delete('-')
      when 'n', 'none' then options = ArchiveHeader::OPTIONS_KCODE_NONE
      when 'e', 'euc'  then options = ArchiveHeader::OPTIONS_KCODE_EUC
      when 's', 'sjis' then options = ArchiveHeader::OPTIONS_KCODE_SJIS
      when 'u', 'utf8' then options = ArchiveHeader::OPTIONS_KCODE_UTF8
      else raise(ExerbError, "unkown kanji code [#{@kcode}]")
      end

      packed_name_table   = @name_table.pack
      packed_file_table   = @file_table.pack
      packed_plugin_table = @plugin_table.pack

      archive_header = ArchiveHeader.new
      archive_header.signature1             = ArchiveHeader::SIGNATURE1
      archive_header.signature2             = ArchiveHeader::SIGNATURE2
      archive_header.options                = options
      archive_header.offset_of_name_table   = Utility.alignment16(archive_header.pack).size
      archive_header.offset_of_file_table   = archive_header.offset_of_name_table + packed_name_table.size
      archive_header.offset_of_plugin_table = archive_header.offset_of_file_table + packed_file_table.size

      return Utility.alignment16(archive_header.pack) + packed_name_table + packed_file_table + packed_plugin_table
    end

    def write_to(io)
      io.write(self.pack)
    end

    def write_to_file(filepath)
      File.open(filepath, 'wb') { |file| self.write_to(file) }
    end

  end # Archive

  class ArchiveHeader

    SIGNATURE1         = 0x52455845
    SIGNATURE2         = 0x03000042
    OPTIONS_KCODE_NONE = 0
    OPTIONS_KCODE_EUC  = 1
    OPTIONS_KCODE_SJIS = 2
    OPTIONS_KCODE_UTF8 = 3

    def initialize
      @signature1             = nil
      @signature2             = nil
      @options                = nil
      @offset_of_name_table   = nil
      @offset_of_file_table   = nil
      @offset_of_plugin_table = nil
    end

    attr_accessor :signature1, :signature2, :options, :offset_of_name_table, :offset_of_file_table, :offset_of_plugin_table

    def pack
      return [@signature1, @signature2, @options, @offset_of_name_table, @offset_of_file_table, @offset_of_plugin_table].pack('LLLLLL')
    end

  end # ArchiveHeader

end # Exerb

#==============================================================================#
#==============================================================================#
