
#==============================================================================#
# $Id: version_info.rb,v 1.8 2004/01/22 21:22:49 yuya Exp $
#==============================================================================#

require 'exerb/utility'
require 'exerb/win32/const/resource'
require 'exerb/win32/struct/vs_fixed_file_info'
require 'exerb/win32/struct/version_info_block'
require 'exerb/resource/base'

#==============================================================================#

module Exerb

  class Resource

    class VersionInfo < Base

      def initialize
        @file_version_number    = nil
        @product_version_number = nil
        @comments               = nil
        @company_name           = nil
        @legal_copyright        = nil
        @legal_trademarks       = nil
        @file_vesion            = nil
        @product_version        = nil
        @product_name           = nil
        @file_description       = nil
        @internal_name          = nil
        @original_filename      = nil
        @private_build          = nil
        @special_build          = nil

        @is_dll = false
      end

      attr_accessor :file_version_number, :product_version_number, :comments, :company_name, :legal_copyright, :legal_trademarks, :file_vesion, :product_version, :product_name, :file_description, :internal_name, :original_filename, :private_build, :special_build, :is_dll

      def self.make_version(n1, n2, n3, n4)
        version  = (n1 & 0xFFFF) << 48
        version |= (n2 & 0xFFFF) << 32
        version |= (n3 & 0xFFFF) << 16
        version |= (n4 & 0xFFFF)

        return version
      end

      def pack
        fixed_file_info = Win32::Struct::VsFixedFileInfo.new
        fixed_file_info.signature          = Win32::Const::VS_FFI_SIGNATURE
        fixed_file_info.struct_version     = Win32::Const::VS_FFI_STRUCVERSION
        fixed_file_info.file_version_ms    = @file_version_number >> 32
        fixed_file_info.file_version_ls    = @file_version_number & 0xFFFFFFFF
        fixed_file_info.product_version_ms = @product_version_number >> 32
        fixed_file_info.product_version_ls = @product_version_number & 0xFFFFFFFF
        fixed_file_info.file_flags_mask    = Win32::Const::VS_FFI_FILEFLAGSMASK
        fixed_file_info.file_flags         = 0x00000000
        fixed_file_info.file_os            = Win32::Const::VOS_NT_WINDOWS32
        fixed_file_info.file_type          = (@is_dll ? Win32::Const::VFT_DLL : Win32::Const::VFT_APP)
        fixed_file_info.file_subtype       = Win32::Const::VFT2_UNKNOWN
        fixed_file_info.file_date_ms       = 0x00000000
        fixed_file_info.file_date_ls       = 0x00000000

        version_info = BlockType0.new('VS_VERSION_INFO', fixed_file_info.pack)
        version_info << BlockType1.new('StringFileInfo') { |string_file_info|
          string_file_info << BlockType1.new('041104b0') { |japanese|
            japanese << self.create_field('Comments',         @comments)
            japanese << self.create_field('CompanyName',      @company_name)
            japanese << self.create_field('LegalCopyright',   @legal_copyright)
            japanese << self.create_field('LegalTrademarks',  @legal_trademarks)
            japanese << self.create_field('FileVersion',      @file_vesion)
            japanese << self.create_field('ProductVersion',   @product_version)
            japanese << self.create_field('ProductName',      @product_name)
            japanese << self.create_field('FileDescription',  @file_description)
            japanese << self.create_field('InternalName',     @internal_name)
            japanese << self.create_field('OriginalFilename', @original_filename)
            japanese << self.create_field('PrivateBuild',     @private_build)
            japanese << self.create_field('SpecialBuild',     @special_build)
          }
        }
        version_info << BlockType1.new('VarFileInfo') { |var_file_info|
          var_file_info << BlockType0.new('Translation', [0x04B00411].pack('L'))
        }

        return version_info.pack
      end

      def create_field(key, value)
        return BlockType1.new(key, (value ? Utility.sjis2unicode(value) + "\0\0" : ''), true)
      end
      protected :create_field

      class Block

        def initialize(type, key = '', value = '', unicode = false)
          @type     = type
          @key      = key
          @value    = value
          @unicode  = unicode
          @children = []

          yield(self) if block_given?
        end

        attr_accessor :type, :key, :value, :unicode, :children

        def <<(child)
          @children << child
        end

        def pack
          packed_children = @children.collect { |child| child.pack }.join

          size_of_value = (@unicode ? @value.size / 2 : @value.size)

          block = Win32::Struct::VersionInfoBlock.new
          block.type         = @type
          block.key          = @key
          block.data         = @value
          block.value_length = size_of_value
#          block.total_length = Utility.alignment(block.pack, 4).size + packed_children.size
          block.total_length = block.pack.size + packed_children.size

          return Utility.alignment(block.pack, 4) + packed_children
        end

      end # Block

      class BlockType0 < Block

        def initialize(key = '', value = '', unicode = false)
          super(0x0000, key, value, unicode)
        end

      end # BlockType0

      class BlockType1 < Block

        def initialize(key = '', value = '', unicode = false)
          super(0x0001, key, value, unicode)
        end

      end # BlockType1

    end # VersionInfo

    class DefaultVersionInfo < VersionInfo

      def initialize
        version_number   = VersionInfo.make_version($1.to_i, $2.to_i, $3.to_i, 0)       if /^(\d+)\.(\d+)\.(\d+)$/ =~ VERSION
        version_number ||= VersionInfo.make_version($1.to_i, $2.to_i, $3.to_i, $4.to_i) if /^(\d+)\.(\d+)\.(\d+)-preview(\d+)$/ =~ VERSION
        version_number ||= VersionInfo.make_version(0, 0, 0, 0)

        @file_version_number    = version_number
        @product_version_number = version_number
        @comments               = 'Generated by Exerb'
        @company_name           = 'Exerb Project'
        @legal_copyright        = 'Copyright(C) Exerb Project, 2001-2004 All rights reserved.'
        @legal_trademarks       = nil
        @file_vesion            = VERSION
        @product_version        = VERSION
        @product_name           = 'Exerb'
        @file_description       = 'Exerb'
        @internal_name          = 'exerb'
        @original_filename      = 'exerb.exe'
        @private_build          = nil
        @special_build          = nil
      end

    end # DefaultVersionInfo

  end # Resource

end # Exerb

#==============================================================================#
#==============================================================================#
