/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.cdi.servlet;

import javax.naming.NamingException;
import javax.naming.Reference;
import org.eclipse.jetty.plus.jndi.Resource;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.webapp.ClasspathPattern;
import org.eclipse.jetty.webapp.WebAppContext;

public class JettyWeldInitializer {
    public static void initWebApp(WebAppContext webapp) throws NamingException {
        JettyWeldInitializer.initContext((ContextHandler)webapp);
        ClasspathPattern systemClasses = webapp.getSystemClasspathPattern();
        systemClasses.add("org.jboss.weld.");
        systemClasses.add("org.jboss.classfilewriter.");
        systemClasses.add("org.jboss.logging.");
        systemClasses.add("com.google.common.");
        systemClasses.add("org.eclipse.jetty.cdi.websocket.annotation.");
        ClasspathPattern serverClasses = webapp.getServerClasspathPattern();
        serverClasses.add("-org.eclipse.jetty.cdi.websocket.annotation.");
        serverClasses.add("-org.eclipse.jetty.cdi.core.");
        serverClasses.add("-org.eclipse.jetty.cdi.servlet.");
        serverClasses.add("-org.jboss.weld.");
        serverClasses.add("-org.jboss.classfilewriter.");
        serverClasses.add("-org.jboss.logging.");
        serverClasses.add("-com.google.common.");
    }

    public static void initContext(ContextHandler handler) throws NamingException {
        handler.setInitParameter("org.jboss.weld.environment.container.class", "org.jboss.weld.environment.jetty.JettyContainer");
        Reference ref = new Reference("javax.enterprise.inject.spi.BeanManager", "org.jboss.weld.resources.ManagerObjectFactory", null);
        new Resource((Object)handler, "BeanManager", (Object)ref);
    }
}

