<?php
/**
@version $Id$
*/

require_once "exForm/Form.php";
require_once "exComponent/DeleteConfirm.php";

class ProcessTodoForm extends exAbstractActionForm
{
	var $id_=array();

	function doGet($data=null)
	{
		// $this->msg_[]=_MD_BXTODO_MESSAGE_INJURY_ACCESS;
		redirect_header('index.php',1,"REQUEST ERROR");
		die;
	}

	function doPost($data=null)
	{
		global $xoopsUser;
		
		if(!is_object($xoopsUser)) {
			$this->msg_[]=_MD_BXTODO_MESSAGE_PERM_DENY;
			return;
		}
		
		$ids=$_POST['id'];
		if(is_array($ids)) {
			foreach($ids as $id) {
				$this->id_[]=intval($id);
			}
		}
		elseif(is_numeric($ids)) {
			$this->id_[]=intval($ids);

			// ¸
			if(!$xoopsUser->isAdmin()) {
    			$handler=&bxTODO::getHandler('todo');
    			foreach ($this->id_[] as $id){
    				$todo =& $handler->get($id);
    				if($todo->getVar('uid')!=$xoopsUser->uid()) {
						$this->msg_[]=_MD_BXTODO_MESSAGE_PERM_DENY;
						return;
    				}
    			}
			}
		}
		
		if(!count($this->id_)) {
			// $this->msg_[]=_MD_BXTODO_MESSAGE_INJURY_ACCESS;
			redirect_header('index.php',1,"REQUEST ERROR");
			die;
		}
	}
}

class TodoDeleteProcessor extends exDeleteConfirmTypicalComponentProcessor {
	function _processDelete(&$component) {
		$handler=&bxTODO::getHandler('todo');

		foreach($component->obj_->id_ as $id) {
			$criteria=new Criteria('id',$id);
			if(!$handler->deletes($criteria))
				return false;
			unset($criteria);
		}

		return true;
	}
}

/**
@brief ΤȤ¾ Typical ʤΤʤΤǡDelete Ѥ
*/
class TodoFinishProcessor extends exDeleteConfirmTypicalComponentProcessor {
	function _processDelete(&$component) {
		$handler=&bxTODO::getHandler('todo');

		foreach($component->obj_->id_ as $id) {
			$todo=&$handler->get($id);
			$todo->setVar('achievement',100);
			if(!$handler->insert($todo))
				return false;
			unset($todo);
		}

		return true;
	}
}

?>