<?php
/**
@file
@brief ToDoѥե
*/

require_once "exForm/Form.php";
require_once "exComponent/Input.php";
require_once XOOPS_ROOT_PATH."/class/xoopsformloader.php";

class ToDoForm extends exAbstractActionForm
{
	function load($data=null)
	{
		global $xoopsUser;

		if(!is_object($xoopsUser)) {
			$this->msg_[]=_MD_NOTEPAD_MESSAGE_GUESTCANCEL;
			return;
		}

		$handler=&bxToDo::getHandler('todo');
		if(isset($_REQUEST['id'])) {
			$id=intval($_REQUEST['id']);
			if($id>0)
				$this->data_=&$handler->get($id);
		}

		if(!is_object($this->data_)) {
			$this->data_=&$handler->create();
			$this->data_->setVar('input_date',time());
			$this->data_->setVar('uid',$xoopsUser->uid());
		}
		else {	// Խ¤Υå
			if(!$xoopsUser->isAdmin() and $this->data_->getVar('uid')!=$xoopsUser->uid()) {
				$this->msg_[]=_MD_BXTODO_MESSAGE_PERM_DENY;
				$this->data_=&$handler->create();
			}
		}
	}

	function doGet($data)
	{
		$this->load();
	}
	
	function doPost($data)
	{
		// ɤ⤷ϥ󥹥󥹤κ
		$this->load();

		if($_POST['is_limit']) {
			$this->data_->setVar('limit_date',exFrame::decodeXoopsFormDateTime($_POST['limit_date']));
		}
		else {
			$this->data_->setVar('limit_date',0);
		}

		$this->data_->setVar('public',(bool)($this->getPositive($_POST['public'])));

		$priority=$this->getPositive($_POST['priority']);
		if(!$this->validateInRange($priority,1,5)) {
			$this->msg_[]=_MD_BXTODO_ERROR_PRIORITY;
		}
		$this->data_->setVar('priority',$priority);

		$achievement=$this->getPositive($_POST['achievement']);
		if($achievement>100) $achievement=100;

		$this->data_->setVar('achievement',$achievement);
		$this->data_->setVar('title',$_POST['title']);
		$this->data_->setVar('ex',$_POST['ex']);

		if(!$this->data_->cleanVars()) {
			$this->msg_=array_merge($this->msg_,$this->data_->getErrors());
		}
	}
}

class ToDoInputComponentRender extends exInputComponentRender {
	function render()
	{
		$form = new XoopsThemeForm('BLOG','blog',$_SERVER['SCRIPT_NAME'],'POST');

		$form->addElement(new XoopsFormHidden('id',$this->component_->form_->data_->getVar('id')));
		$form->addElement(new XoopsFormText(_MD_BXTODO_LANG_TITLE,'title',35,35,$this->component_->form_->data_->getVar('title')));
		$radio = new XoopsFormRadio(_MD_BXTODO_LANG_ISLIMITED,'is_limit',(bool)($this->component_->form_->data_->getVar('limit_date')));
		$radio->addOption(1,_MD_BXTODO_LANG_LIMITED);
		$radio->addOption(0,_MD_BXTODO_LANG_UNLIMITED);
		$form->addElement($radio);

		$form->addElement(new XoopsFormDateTime(_MD_BXTODO_LANG_LIMIT_DATE,'limit_date',15,$this->component_->form_->data_->getVar('limit_date')));

		$priority=new XoopsFormSelect(_MD_BXTODO_LANG_PRIORITY,'priority',$this->component_->form_->data_->getVar('priority'));
		$priority->addOption(1,1);
		$priority->addOption(2,2);
		$priority->addOption(3,3);
		$priority->addOption(4,4);
		$priority->addOption(5,5);
		$form->addElement($priority);
		
		$achievement=new XoopsFormSelect(_MD_BXTODO_LANG_ACHIEVEMENT,'achievement',$this->component_->form_->data_->getVar('achievement'));
		$achievement->addOption(0,_MD_BXTODO_LANG_NOSTART);
		$achievement->addOption(100,_MD_BXTODO_LANG_FINISHED);
		$form->addElement($achievement);

		$public=new XoopsFormSelect(_MD_BXTODO_LANG_PUBLIC,"public",$this->component_->form_->data_->getVar('public'));
		$public->addOption(0,_MD_BXTODO_LANG_PRIVATE);
		$public->addOption(1,_MD_BXTODO_LANG_PUBLIC);
		$form->addElement($public);

		$form->addElement(new XoopsFormDhtmlTextArea(_MD_BXTODO_LANG_EX,'ex',$this->component_->form_->data_->getVar('ex','e')));

		$form->addElement(new XoopsFormButton('SAVE',"submit","submit","submit"));

		$form->display();
	}
}

?>