<?php
/**
@brief Ȥ򤷤᤹ DataObject ե
@author minahito
@version $Id: comment.php,v 1.2 2004/08/09 11:34:36 minahito Exp $
*/

require_once "xoops/class.object.php";
require_once "xoops/user.php";

class xixiBlogCommentObject extends exXoopsObject
{
	function xixiBlogCommentObject($id=null)
	{
		$this->initVar('cid', XOBJ_DTYPE_INT, 0, false);
		$this->initVar('id', XOBJ_DTYPE_INT, 0, false);
		$this->initVar('uid', XOBJ_DTYPE_INT, 0, false);
		$this->initVar('input_date', XOBJ_DTYPE_INT, time(), false);
		$this->initVar('ip', XOBJ_DTYPE_TXTBOX, null, true, 32);
		$this->initVar('name', XOBJ_DTYPE_TXTBOX, null, true, 64);
		$this->initVar('message', XOBJ_DTYPE_TXTAREA, null, true, null);
		
		if(is_array($id))
			$this->assignVars($id);
	}

	function &getStructure($type='s')
	{
		$ret =& parent::getStructure($type);

   		$uHandler=&xoops_gethandler('user');
   		$user = new exXoopsUserObject($uHandler->get($this->getVar('uid')));
   		$ret['user']=$user->getArray($type);
		return $ret;
	}

	function &getShortStructure($type='s',$length=64)
	{
		$ret=$this->getStructure($type);

		// åû̽
		$message = $this->getVar('message');
		if (XOOPS_USE_MULTIBYTES == 1 && function_exists('mb_internal_encoding') && @mb_internal_encoding(_CHARSET)) {
			$str2=mb_strcut($message,0,$length-strlen("..."));
			$ret['message'] = $str2.( mb_strlen($message)!=mb_strlen($str2) ? "..." : '' );
		}
		else
			$ret['message'] = substr($message, 0, $length - strlen("..."))."...";
		return $ret;
	}

	/**
	Υ֥Ȥȥǡ١Ȥ³ˡ֤
	*/
	function &getTableInfo()
	{
		$tinfo = new exTableInfomation('xixiblog_comment','cid');
		return ($tinfo);
	}
}

class xixiBlogBlogcommentObject extends xixiBlogCommentObject
{
	/**
	Υ֥Ȥȥǡ١Ȥ³ˡ֤
	*/
	function &getTableInfo()
	{
		$tinfo = new exTableInfomation(array('xixiblog_comment c','xixiblog_blog b'),
			'c.cid','c.id=b.id',null,'c.*');
		return ($tinfo);
	}
}
?>