<?php
/**
@version $Id: blogcalen.php,v 1.2 2004/08/09 14:32:32 minahito Exp $
*/

class BlogCalendar
{
	var $uid_;
	var $year_;	/**< ǯʣ */
	var $month_;	/**<  */
	var $days_=array();	/**< boolean array */
	
	/**
	@param $date UNIXTIME
	*/
	function BlogCalendar($uid,$date=0)
	{
		if($date) {
			$this->year_=intval(date("Y",$date));
			$this->month_=intval(date("m",$date));
			$this->reset();
		}
		$this->uid_=$uid;
	}

	function setYear($year)
	{
		$this->year_=$year;
	}

	function setMonth($month)
	{
		$this->month_=$month;
	}
	
	function getYear()
	{
		return $this->year_;
	}
	
	function getMonth()
	{
		return $this->month_;
	}
	
	/**
	@brief դ˴ؤ򥯥ꥢϢľޤץѥƥ year_ month_ åƥ󥰤Ǥ
	*/
	function reset()
	{
		unset($this->days_);
		$this->days_=array();
		$maxday=date('t',$this->getCalendar_date());
		for($i=1;$i<=$maxday;$i++)
			$this->days_[$i]=0;
	}

	function addDays($arr)
	{
		foreach($arr as $time)
			$this->addDay($time);
	}

	function getCalendar_date()
	{
		return mktime(0,0,0,$this->month_,1,$this->year_);
	}

	/**
	@brief ꤵ줿 unixtime ֥ΤդȤɲäޤ
	@return bool ݡ󥹥󥹤ǯȷۤʤäƤ false ֤ޤ
	*/
	function addDay($unixtime)
	{
		$year=intval(date("Y",$unixtime));
		$month=intval(date("m",$unixtime));
		$day=intval(date('d',$unixtime));

		if($year==$this->year_ && $month==$this->month_ && isset($this->days_[$day])) {
			$this->days_[$day]=true;
			return true;
		}
		else {
			return false;
		}
	}

	function removeDays($arr)
	{
		foreach($arr as $time)
			$this->removeDay($time);
	}

	/**
	@brief ꤵ줿 unixtime ֥ΤդȤƺޤ
	@return bool ݡ󥹥󥹤ǯȷۤʤäƤ false ֤ޤоݤʤƤоʤ true ֤ޤ
	*/
	function removeDay($unixtime)
	{
		$year=intval(date("Y",$unixtime));
		$month=intval(date("m",$unixtime));
		$day=intval(date('d',$unixtime));

		if($year==$this->year_ && $month==$this->month_ && isset($this->days_[$day])) {
			$this->days_[$day]=false;
			return true;
		}
		else {
			return false;
		}
	}

	/**
	@brief Ϥ줿դ
	*/
	function getWeek($day)
	{
		// ĥ顼󤴤ʤ
		$time=mktime(0,0,0,$this->month_,$day,$this->year_);
		return date("w",$time);
	}

	/**
	@brief Smarty 䤹ǽϤ(xoops ξ祤󥹥󥹤˥Ǥʤ
	@param $type ǤϥߡǤ
	@return array $ret[][()]['exist'] = bool / $ret[][()]['day'] =  / $ret[][]['query_string']
	*/
	function getStructure($type=null)
	{
		$row=0;
		$col=$this->getWeek(1);

		for($i=0;$i<$col;$i++) {
			$ret[$row][$i]=array('exist'=>false, 'day'=>'', 'query_string'=>'');
		}

		$maxday=count($this->days_);
		for($i=1;$i<=$maxday;$i++) {
			if($col>=7) {
				$row++;
				$col=0;
			}
			$ret[$row][$col]['day']=$i;
			$ret[$row][$col]['exist']=(bool)($this->days_[$i]);
			if($this->days_[$i])
				$ret[$row][$col]['query_string']="uid=".$this->uid_."&amp;date=".mktime(0,0,0,$this->month_,$i,$this->year_);
			else
				$ret[$row][$col]['query_string']="";
			$col++;
		}
		
		for ( ; $col<=6 ; $col++ )
			$ret[$row][$col]=array('exist'=>false, 'day'=>'', 'query_string'=>'');
		
		return $ret;
	}

	/**
	@brief ξϢ֤ޤη˥֥硢 unixtime  unixtime ˳Ǽ֤ޤ
	@return array 'year' 'month' 'query_string' 'unixtime'=> ֥ʤ0
	*/
	function getPreviousStructure()
	{
		$unixtime=mktime(0,0,0,$this->month_,1,$this->year_);
		$handler=&xixiBlog::getHandler('blog');
		$criteria=new CriteriaCompo();
		$criteria->add(new Criteria('uid',$this->uid_));
		$criteria->add(new Criteria('input_date',$unixtime,'<'));

		$month=$this->month_-1;
		if(!$month) {
			$year=$this->year_-1;
			$month=12;
		}
		else
			$year=$this->year_;

		$ret=array('year'=>$year,'month'=>$month);

		if($count=$handler->getCount($criteria)) {
			$ret['unixtime']=mktime(0,0,0,$month,1,$year);
			$ret['query_string']='uid='.$this->uid_.'&amp;'.'date='.$ret['unixtime'];
		}
		else {
			$ret['unixtime']=0;
			$ret['query_string']='';
		}

		return $ret;
	}

	/**
	@brief ξϢ֤ޤη˥֥硢 unixtime  unixtime ˳Ǽ֤ޤ
	@return array 'year' 'month' 'unixtime'=> ֥ʤ0
	*/
	function getNextStructure()
	{
		$month=$this->month_+1;
		if($month>12) {
			$year=$this->year_+1;
			$month=1;
		}
		else
			$year=$this->year_;
			
		$unixtime=mktime(0,0,0,$month,1,$year);
		$handler=&xixiBlog::getHandler('blog');
		$criteria=new CriteriaCompo();
		$criteria->add(new Criteria('uid',$this->uid_));
		$criteria->add(new Criteria('input_date',$unixtime,'>='));

		$ret=array('year'=>$year,'month'=>$month);

		if($handler->getCount($criteria)) {
			$ret['unixtime']=$unixtime;
			$ret['query_string']='uid='.$this->uid_.'&amp;'.'date='.$unixtime;
		}
		else {
			$ret['unixtime']=0;
			$ret['query_string']='';
		}


		return $ret;
	}

}

class BlogCalendarHandler
{
	/**
	@brief  unixtime  00:00:00  unixtime ֤
	*/
	function makeZeroTime($date)
	{
		$year=intval(date("Y",$date));
		$month=intval(date("m",$date));
		$day=intval(date("d",$date));
		return mktime(0,0,0,$month,$day,$year);
	}

	function &load($uid,$date)
	{
		global $__blogcalen_cache__;
		
		if(isset($__blogcalen_cache__[$uid][$date]))
			return $__blogcalen_cache__[$uid][$date];
		
		$year=intval(date("Y",$date));
		$month=intval(date("m",$date));
		$date=mktime(0,0,0,$month,1,$year);

		$handler=&xixiBlog::getHandler('calendar');
		$calen=&$handler->get($uid,$date);
		if(is_object($calen)) {
			$obj= new BlogCalendar($uid,$date);
			$obj->days_=unserialize($calen->getVar('serialize'));

			$__blogcalen_cache__[$uid][$date]=&$obj;
			return $obj;
		}
		else {
			$obj= new BlogCalendar($uid,$date);

			$__blogcalen_cache__[$uid][$date]=&$obj;
			return $obj;
		}
	}

	function save($obj)
	{
		$handler=&xixiBlog::getHandler('calendar');
		$calen=&$handler->get($obj->uid_,$obj->getCalendar_date());
		if(!is_object($calen)) {
			$calen=&$handler->create();
			$calen->setVar('uid',$obj->uid_);
			$calen->setVar('calendar_date',$obj->getCalendar_date());
		}
		$calen->setVar('serialize',serialize($obj->days_));
		return $handler->insert($calen);
	}
}

?>