<?php

require_once XOOPS_MODULE_PATH . "/cuestion/class/AbstractEditAction.class.php";
require_once XOOPS_MODULE_PATH . "/cuestion/forms/AnswerEditForm.class.php";

class Cuestion_AnswerEditAction extends Cuestion_AbstractEditAction
{
	function _getId()
	{
		return isset($_REQUEST['answer_id']) ? $_REQUEST['answer_id'] : 0;
	}

	function &_getHandler()
	{
		$handler =& xoops_getmodulehandler('answer');
		return $handler;
	}

	function _setupActionForm()
	{
		$this->mActionForm =& new Cuestion_AnswerEditForm();
		$this->mActionForm->prepare();
	}

	function prepare(&$controller, &$xoopsUser)
	{
		parent::prepare($controller, $xoopsUser);
		if ($this->mObject->isNew()) {
			$this->mObject->set('question_id', xoops_getrequest('question_id'));
			$this->mObject->set('uid', $xoopsUser->get('uid'));
		}
	}
	
	function executeViewInput(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName("cuestion_answer_edit.html");
		$render->setAttribute('actionForm', $this->mActionForm);
		$this->mObject->loadQuestion();
		$render->setAttribute('object', $this->mObject);
		
		$questionHandler =& xoops_getmodulehandler('question');
		$questionArr =& $questionHandler->getObjects();
		foreach (array_keys($questionArr) as $key) {
			$questionArr[$key]->loadAnswer();
			$questionArr[$key]->loadKeyqlink();
			$questionArr[$key]->loadCategory();
		}
		$render->setAttribute('questionArr', $questionArr);
	}

	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward("./index.php?action=AnswerList&question_id=" . $this->mObject->get('question_id'));
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
		redirect_header("./index.php?action=AnswerList", 1, _MD_CUESTION_ERROR_DBUPDATE_FAILED);
	}
}

?>
