<?php

require_once XOOPS_MODULE_PATH . "/cuestion/class/PageNavigator.class.php";
require_once XOOPS_MODULE_PATH . "/cuestion/class/AbstractListAction.class.php";
require_once XOOPS_MODULE_PATH . "/cuestion/forms/AnswerFilterForm.class.php";
require_once XOOPS_MODULE_PATH . "/cuestion/forms/RatingPostForm.class.php";
require_once XOOPS_MODULE_PATH . "/cuestion/forms/KeyqlinkEditForm.class.php";

class Cuestion_AnswerListAction extends Cuestion_AbstractListAction
{
	var $mQuestion = null;
	var $mActionForm = null;
	
	var $mKeywordActionForm = null;

	function prepare(&$controller, &$xoopsUser)
	{
		//
		// Prepare actionform
		//
		$this->mActionForm =& new Cuestion_RatingPostForm();
		$this->mActionForm->prepare();
		
		$this->mKeywordActionForm =& new Cuestion_KeyqlinkEditForm();
		$this->mKeywordActionForm->prepare();
	}
	
	function &_getHandler()
	{
		$handler =& xoops_getmodulehandler('answer');
		return $handler;
	}

	function &_getFilterForm(&$navi)
	{
		$filter =& new Cuestion_AnswerFilterForm($navi);
		return $filter;
	}

	function _getBaseUrl()
	{
		return "./index.php?action=AnswerList";
	}

	function getDefaultView(&$controller, &$xoopsUser)
	{
		//
		// Count up
		//
		$handler =& xoops_getmodulehandler('question');
		$this->mQuestion =& $handler->get(xoops_getrequest('question_id'));

		$this->mQuestion->set('count', $this->mQuestion->get('count') + 1 );
		$handler->insert($this->mQuestion, true);

		return parent::getDefaultView($controller, $xoopsUser);
	}
	
	function execute(&$controller, &$xoopsUser)
	{
		$this->mActionForm->fetch();
		$this->mActionForm->validate();
		
		if ($this->mActionForm->hasError())
		{
			return $this->getDefaultView($controller, $xoopsUser);
		}
		
		if (is_object($xoopsUser))
		{
			$handler =& xoops_getmodulehandler('rating');
			
			$rating =& $handler->create();

			$this->mActionForm->update($rating);

			$rating->set('uid', $xoopsUser->get('uid'));
			
			$handler->insert($rating);
		}
		
		$handler =& xoops_getmodulehandler('question');
		$question =& $handler->get($this->mActionForm->get('question_id'));
		
		$question->calculateRating();
		
		$handler->insert($question);
		
		return CUESTION_FRAME_VIEW_SUCCESS;
	}
	
	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward('./index.php?action=AnswerList&question_id=' . $this->mActionForm->get('question_id'));
	}

	function executeViewIndex(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName("cuestion_answer_list.html");
		foreach (array_keys($this->mObjects) as $key) {
			$this->mObjects[$key]->loadQuestion();
			$this->mObjects[$key]->loadUser();
		}
		$render->setAttribute("objects", $this->mObjects);
		$render->setAttribute("pageNavi", $this->mNavi);
		
		$this->mQuestion->loadUser();
		$render->setAttribute('question', $this->mQuestion);
		
		// cubson::entity_assign('rating_message');
		$rating_messageHandler =& xoops_getmodulehandler('rating_message');
		$criteria =& new Criteria('rating_message_id', '0', '>');
		$criteria->setSort('point');
		$rating_messageArr =& $rating_messageHandler->getObjects($criteria);
		$render->setAttribute('rating_messageArr', $rating_messageArr);
		
		$render->setAttribute('actionForm', $this->mActionForm);
		$render->setAttribute('keywordActionForm', $this->mKeywordActionForm);
		
		$render->setAttribute('currentUser', $xoopsUser);
		
		// cubson::entity_assign('keyword');
		$keywordHandler =& xoops_getmodulehandler('keyword');
		$keywordArr =& $keywordHandler->getObjects();
		foreach (array_keys($keywordArr) as $key) {
			$keywordArr[$key]->loadKeyqlink();
		}
		$render->setAttribute('keywordArr', $keywordArr);
	}
}

?>
