<?php

require_once XOOPS_MODULE_PATH . "/cuestion/class/AbstractEditAction.class.php";
require_once XOOPS_MODULE_PATH . "/cuestion/forms/KeyqlinkEditForm.class.php";

class Cuestion_KeyqlinkEditAction extends Cuestion_AbstractEditAction
{
	function _getId()
	{
		return isset($_REQUEST['keyqlink_id']) ? $_REQUEST['keyqlink_id'] : 0;
	}

	function &_getHandler()
	{
		$handler =& xoops_getmodulehandler('keyqlink');
		return $handler;
	}

	function _setupActionForm()
	{
		$this->mActionForm =& new Cuestion_KeyqlinkEditForm();
		$this->mActionForm->prepare();
	}

	function getDefaultView(&$controller, &$xoopsUser)
	{
		return CUESTION_FRAME_VIEW_ERROR;
	}

	function execute(&$controller, &$xoopsUser)
	{
		$this->mActionForm->fetch();
		$this->mActionForm->validate();
		
		if($this->mActionForm->hasError()) {
			return CUESTION_FRAME_VIEW_INPUT;
		}
		
		$handler =& $this->_getHandler();
		$handler->deleteAll(new Criteria('question_id', $this->mActionForm->get('question_id')));
		
		$keyIds = $this->mActionForm->get('keyword_id');
		
		foreach ($keyIds as $_key => $_value) {
			if ($_value == 1) {
				$t_obj =& $handler->create();
				$t_obj->set('question_id', $this->mActionForm->get('question_id'));
				$t_obj->set('keyword_id', $_key);
				
				$handler->insert($t_obj);
			}
		}
		
		return CUESTION_FRAME_VIEW_SUCCESS;
	}

	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward("./index.php?action=AnswerList&question_id=" . $this->mActionForm->get('question_id'));
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
		redirect_header("./index.php", 1, _MD_CUESTION_ERROR_DBUPDATE_FAILED);
	}
}

?>
