<?php

require_once XOOPS_MODULE_PATH . "/cuestion/class/AbstractEditAction.class.php";
require_once XOOPS_MODULE_PATH . "/cuestion/forms/ReportEditForm.class.php";

class Cuestion_ReportEditAction extends Cuestion_AbstractEditAction
{
	function _getId()
	{
		return isset($_REQUEST['question_id']) ? $_REQUEST['question_id'] : 0;
	}

	function &_getHandler()
	{
		$handler =& xoops_getmodulehandler('question');
		return $handler;
	}

	function _setupActionForm()
	{
		$this->mActionForm =& new Cuestion_ReportEditForm();
		$this->mActionForm->prepare();
	}

	function prepare(&$controller, &$xoopsUser)
	{
		parent::prepare($controller, $xoopsUser);
		if ($this->mObject->isNew()) {
			$this->mObject->set('category_id', xoops_getrequest('category_id'));
			$this->mObject->set('uid', $xoopsUser->get('uid'));
		}
	}

	function isEnableCreate()
	{
		return false;
	}
	
	function isPerm(&$controller, &$xoopsUser)
	{
		if (!is_object($xoopsUser)) {
			return false;
		}

		return ($this->mObject->get('uid') == $xoopsUser->get('uid')) && $this->mObject->get('is_open');
	}
	
	function executeViewInput(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName("cuestion_report_edit.html");
		$render->setAttribute('actionForm', $this->mActionForm);
		$this->mObject->loadAnswer();
		$this->mObject->loadKeyqlink();
		$this->mObject->loadCategory();
		$render->setAttribute('object', $this->mObject);
	}

	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward("./index.php?action=QuestionList&category_id=" . $this->mObject->get('category_id'));
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
		redirect_header("./index.php?action=QuestionList", 1, _MD_CUESTION_ERROR_DBUPDATE_FAILED);
	}
}

?>
