<?php

require_once XOOPS_ROOT_PATH . "/class/XCube_ActionForm.class.php";
require_once XOOPS_MODULE_PATH . "/base/class/Legacy_Validator.class.php";

class Cuestion_CategoryAdminEditForm extends XCube_ActionForm
{
	function getTokenName()
	{
		return "module.cuestion.CategoryAdminEditForm.TOKEN";
	}

	function prepare()
	{
		//
		// Set form properties
		//
		$this->mFormProperties['category_id'] =& new XCube_IntProperty('category_id');
		$this->mFormProperties['parent_id'] =& new XCube_IntProperty('parent_id');
		$this->mFormProperties['name'] =& new XCube_StringProperty('name');
		$this->mFormProperties['description'] =& new XCube_TextProperty('description');
		$this->mFormProperties['priority'] =& new XCube_IntProperty('priority');
	
		//
		// Set field properties
		//
	
		$this->mFieldProperties['category_id'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['category_id']->setDependsByArray(array('required'));
		$this->mFieldProperties['category_id']->addMessage('required', _AD_CUESTION_ERROR_REQUIRED, _AD_CUESTION_LANG_CATEGORY_ID);
	
		$this->mFieldProperties['parent_id'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['parent_id']->setDependsByArray(array('required'));
		$this->mFieldProperties['parent_id']->addMessage('required', _AD_CUESTION_ERROR_REQUIRED, _AD_CUESTION_LANG_PARENT_ID);
	
		$this->mFieldProperties['name'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['name']->setDependsByArray(array('required','maxlength'));
		$this->mFieldProperties['name']->addMessage('required', _AD_CUESTION_ERROR_REQUIRED, _AD_CUESTION_LANG_NAME, '255');
		$this->mFieldProperties['name']->addMessage('maxlength', _AD_CUESTION_ERROR_MAXLENGTH, _AD_CUESTION_LANG_NAME, '255');
		$this->mFieldProperties['name']->addVar('maxlength', '255');
	
		$this->mFieldProperties['description'] =& new XCube_FieldProperty($this);
	
		$this->mFieldProperties['priority'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['priority']->setDependsByArray(array('required'));
		$this->mFieldProperties['priority']->addMessage('required', _AD_CUESTION_ERROR_REQUIRED, _AD_CUESTION_LANG_PRIORITY);
	}

	function load(&$obj)
	{
		$this->set('category_id', $obj->get('category_id'));
		$this->set('parent_id', $obj->get('parent_id'));
		$this->set('name', $obj->get('name'));
		$this->set('description', $obj->get('description'));
		$this->set('priority', $obj->get('priority'));
	}

	function update(&$obj)
	{
		$obj->set('category_id', $this->get('category_id'));
		$obj->set('parent_id', $this->get('parent_id'));
		$obj->set('name', $this->get('name'));
		$obj->set('description', $this->get('description'));
		$obj->set('priority', $this->get('priority'));
	}
}

?>
