<?php

require_once XOOPS_ROOT_PATH . "/class/XCube_ActionForm.class.php";
require_once XOOPS_MODULE_PATH . "/base/class/Legacy_Validator.class.php";

class Cuestion_FaqAdminEditForm extends XCube_ActionForm
{
	function getTokenName()
	{
		return "module.cuestion.FaqAdminEditForm.TOKEN";
	}

	function prepare()
	{
		//
		// Set form properties
		//
		$this->mFormProperties['faq_id'] =& new XCube_IntProperty('faq_id');
		$this->mFormProperties['category_id'] =& new XCube_IntProperty('category_id');
		$this->mFormProperties['subject'] =& new XCube_StringProperty('subject');
		$this->mFormProperties['body'] =& new XCube_TextProperty('body');
		$this->mFormProperties['create_unixtime'] =& new XCube_IntProperty('create_unixtime');
		$this->mFormProperties['update_unixtime'] =& new XCube_IntProperty('update_unixtime');
	
		//
		// Set field properties
		//
	
		$this->mFieldProperties['faq_id'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['faq_id']->setDependsByArray(array('required'));
		$this->mFieldProperties['faq_id']->addMessage('required', _AD_CUESTION_ERROR_REQUIRED, _AD_CUESTION_LANG_FAQ_ID);
	
		$this->mFieldProperties['category_id'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['category_id']->setDependsByArray(array('required','objectExsist'));
		$this->mFieldProperties['category_id']->addMessage('required', _AD_CUESTION_ERROR_REQUIRED, _AD_CUESTION_LANG_CATEGORY_ID);
		$this->mFieldProperties['category_id']->addMessage('objectExist', _AD_CUESTION_ERROR_OBJECT_EXIST, _AD_CUESTION_LANG_CATEGORY_ID);
		$this->mFieldProperties['category_id']->addVar('handler', 'category');
	
		$this->mFieldProperties['subject'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['subject']->setDependsByArray(array('required','maxlength'));
		$this->mFieldProperties['subject']->addMessage('required', _AD_CUESTION_ERROR_REQUIRED, _AD_CUESTION_LANG_SUBJECT, '255');
		$this->mFieldProperties['subject']->addMessage('maxlength', _AD_CUESTION_ERROR_MAXLENGTH, _AD_CUESTION_LANG_SUBJECT, '255');
		$this->mFieldProperties['subject']->addVar('maxlength', '255');
	
		$this->mFieldProperties['body'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['body']->setDependsByArray(array('required'));
		$this->mFieldProperties['body']->addMessage('required', _AD_CUESTION_ERROR_REQUIRED, _AD_CUESTION_LANG_BODY);
	
		$this->mFieldProperties['create_unixtime'] =& new XCube_FieldProperty($this);
	
		$this->mFieldProperties['update_unixtime'] =& new XCube_FieldProperty($this);
	}

	function load(&$obj)
	{
		$this->set('faq_id', $obj->get('faq_id'));
		$this->set('category_id', $obj->get('category_id'));
		$this->set('subject', $obj->get('subject'));
		$this->set('body', $obj->get('body'));
		$this->set('create_unixtime', $obj->get('create_unixtime'));
		$this->set('update_unixtime', $obj->get('update_unixtime'));
	}

	function update(&$obj)
	{
		$obj->set('faq_id', $this->get('faq_id'));
		$obj->set('category_id', $this->get('category_id'));
		$obj->set('subject', $this->get('subject'));
		$obj->set('body', $this->get('body'));
		$obj->set('update_unixtime', time());
	}
}

?>
